@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The number of instances that can be used during this profile.
 * @property default the number of instances that will be set if metrics are not available for evaluation. The default is only used if the current instance count is lower than the default.
 * @property maximum the maximum number of instances for the resource. The actual maximum number of instances is limited by the cores that are available in the subscription.
 * @property minimum the minimum number of instances for the resource.
 */
public data class ScaleCapacityResponse(
    public val default: String,
    public val maximum: String,
    public val minimum: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ScaleCapacityResponse): ScaleCapacityResponse = ScaleCapacityResponse(
            default = javaType.default_(),
            maximum = javaType.maximum(),
            minimum = javaType.minimum(),
        )
    }
}
