@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies an auto scale rule metric dimension.
 * @property dimensionName Name of the dimension.
 * @property operator the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values
 * @property values list of dimension values. For example: ["App1","App2"].
 */
public data class ScaleRuleMetricDimensionResponse(
    public val dimensionName: String,
    public val `operator`: String,
    public val values: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.ScaleRuleMetricDimensionResponse): ScaleRuleMetricDimensionResponse = ScaleRuleMetricDimensionResponse(
            dimensionName = javaType.dimensionName(),
            `operator` = javaType.`operator`(),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
