@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An SMS receiver.
 * @property countryCode The country code of the SMS receiver.
 * @property name The name of the SMS receiver. Names must be unique across all receivers within a tenant action group.
 * @property phoneNumber The phone number of the SMS receiver.
 * @property status The status of the receiver.
 */
public data class SmsReceiverResponse(
    public val countryCode: String,
    public val name: String,
    public val phoneNumber: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.SmsReceiverResponse): SmsReceiverResponse = SmsReceiverResponse(
            countryCode = javaType.countryCode(),
            name = javaType.name(),
            phoneNumber = javaType.phoneNumber(),
            status = javaType.status(),
        )
    }
}
