@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property containerName The container name of the Storage Blob.
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 * @property storageAccountResourceId The resource ID of the storage account.
 */
public data class StorageBlobDestinationResponse(
    public val containerName: String? = null,
    public val name: String? = null,
    public val storageAccountResourceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.StorageBlobDestinationResponse): StorageBlobDestinationResponse = StorageBlobDestinationResponse(
            containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            storageAccountResourceId = javaType.storageAccountResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
