@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name A friendly name for the destination.
 * This name should be unique across all destinations (regardless of type) within the data collection rule.
 * @property storageAccountResourceId The resource ID of the storage account.
 * @property tableName The name of the Storage Table.
 */
public data class StorageTableDestinationResponse(
    public val name: String? = null,
    public val storageAccountResourceId: String? = null,
    public val tableName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.StorageTableDestinationResponse): StorageTableDestinationResponse = StorageTableDestinationResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            storageAccountResourceId = javaType.storageAccountResourceId().map({ args0 -> args0 }).orElse(null),
            tableName = javaType.tableName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
