@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Declaration of a custom stream.
 * @property columns List of columns used by data in this stream.
 */
public data class StreamDeclarationResponse(
    public val columns: List<ColumnDefinitionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.StreamDeclarationResponse): StreamDeclarationResponse = StreamDeclarationResponse(
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.ColumnDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
