@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Definition of which syslog data will be collected and how it will be collected.
 * Only collected from Linux machines.
 * @property facilityNames The list of facility names.
 * @property logLevels The log levels to collect.
 * @property name A friendly name for the data source.
 * This name should be unique across all data sources (regardless of type) within the data collection rule.
 * @property streams List of streams that this data source will be sent to.
 * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will be sent to.
 */
public data class SyslogDataSourceResponse(
    public val facilityNames: List<String>? = null,
    public val logLevels: List<String>? = null,
    public val name: String? = null,
    public val streams: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.SyslogDataSourceResponse): SyslogDataSourceResponse = SyslogDataSourceResponse(
            facilityNames = javaType.facilityNames().map({ args0 -> args0 }),
            logLevels = javaType.logLevels().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            streams = javaType.streams().map({ args0 -> args0 }),
        )
    }
}
