@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Geo-physical location to run a WebTest from. You must specify one or more locations for the test to run from.
 * @property location Location ID for the WebTest to run from.
 */
public data class WebTestGeolocationResponse(
    public val location: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WebTestGeolocationResponse): WebTestGeolocationResponse = WebTestGeolocationResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
        )
    }
}
