@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * The collection of validation rule properties
 * @property contentValidation The collection of content validation properties
 * @property expectedHttpStatusCode Validate that the WebTest returns the http status code provided.
 * @property ignoreHttpStatusCode When set, validation will ignore the status code.
 * @property sSLCertRemainingLifetimeCheck A number of days to check still remain before the the existing SSL cert expires.  Value must be positive and the SSLCheck must be set to true.
 * @property sSLCheck Checks to see if the SSL cert is still valid.
 */
public data class WebTestPropertiesResponseValidationRules(
    public val contentValidation: WebTestPropertiesResponseContentValidation? = null,
    public val expectedHttpStatusCode: Int? = null,
    public val ignoreHttpStatusCode: Boolean? = null,
    public val sSLCertRemainingLifetimeCheck: Int? = null,
    public val sSLCheck: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WebTestPropertiesResponseValidationRules): WebTestPropertiesResponseValidationRules = WebTestPropertiesResponseValidationRules(
            contentValidation = javaType.contentValidation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.insights.kotlin.outputs.WebTestPropertiesResponseContentValidation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            expectedHttpStatusCode = javaType.expectedHttpStatusCode().map({ args0 -> args0 }).orElse(null),
            ignoreHttpStatusCode = javaType.ignoreHttpStatusCode().map({ args0 -> args0 }).orElse(null),
            sSLCertRemainingLifetimeCheck = javaType.sSLCertRemainingLifetimeCheck().map({ args0 ->
                args0
            }).orElse(null),
            sSLCheck = javaType.sSLCheck().map({ args0 -> args0 }).orElse(null),
        )
    }
}
