@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Specifies the metric alert rule criteria for a web test resource.
 * @property componentId The Application Insights resource Id.
 * @property failedLocationCount The number of failed locations.
 * @property odataType specifies the type of the alert criteria.
 * Expected value is 'Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria'.
 * @property webTestId The Application Insights web test Id.
 */
public data class WebtestLocationAvailabilityCriteriaResponse(
    public val componentId: String,
    public val failedLocationCount: Double,
    public val odataType: String,
    public val webTestId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WebtestLocationAvailabilityCriteriaResponse): WebtestLocationAvailabilityCriteriaResponse = WebtestLocationAvailabilityCriteriaResponse(
            componentId = javaType.componentId(),
            failedLocationCount = javaType.failedLocationCount(),
            odataType = javaType.odataType(),
            webTestId = javaType.webTestId(),
        )
    }
}
