@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.insights.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Gallery information for a workbook template.
 * @property category Category for the gallery.
 * @property name Name of the workbook template in the gallery.
 * @property order Order of the template within the gallery.
 * @property resourceType Azure resource type supported by the gallery.
 * @property type Type of workbook supported by the workbook template.
 */
public data class WorkbookTemplateGalleryResponse(
    public val category: String? = null,
    public val name: String? = null,
    public val order: Int? = null,
    public val resourceType: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.insights.outputs.WorkbookTemplateGalleryResponse): WorkbookTemplateGalleryResponse = WorkbookTemplateGalleryResponse(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            order = javaType.order().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
