@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin

import com.pulumi.azurenative.integrationspaces.IntegrationspacesFunctions.getApplicationBusinessProcessDevelopmentArtifactPlain
import com.pulumi.azurenative.integrationspaces.IntegrationspacesFunctions.getApplicationPlain
import com.pulumi.azurenative.integrationspaces.IntegrationspacesFunctions.getApplicationResourcePlain
import com.pulumi.azurenative.integrationspaces.IntegrationspacesFunctions.getBusinessProcessPlain
import com.pulumi.azurenative.integrationspaces.IntegrationspacesFunctions.getInfrastructureResourcePlain
import com.pulumi.azurenative.integrationspaces.IntegrationspacesFunctions.getSpacePlain
import com.pulumi.azurenative.integrationspaces.IntegrationspacesFunctions.listApplicationBusinessProcessDevelopmentArtifactsPlain
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetApplicationBusinessProcessDevelopmentArtifactPlainArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetApplicationBusinessProcessDevelopmentArtifactPlainArgsBuilder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetApplicationResourcePlainArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetApplicationResourcePlainArgsBuilder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetBusinessProcessPlainArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetBusinessProcessPlainArgsBuilder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetInfrastructureResourcePlainArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetInfrastructureResourcePlainArgsBuilder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetSpacePlainArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.GetSpacePlainArgsBuilder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.ListApplicationBusinessProcessDevelopmentArtifactsPlainArgsBuilder
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetApplicationBusinessProcessDevelopmentArtifactResult
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetApplicationResourceResult
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetApplicationResult
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetBusinessProcessResult
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetInfrastructureResourceResult
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetSpaceResult
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.ListApplicationBusinessProcessDevelopmentArtifactsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetApplicationBusinessProcessDevelopmentArtifactResult.Companion.toKotlin as getApplicationBusinessProcessDevelopmentArtifactResultToKotlin
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetApplicationResourceResult.Companion.toKotlin as getApplicationResourceResultToKotlin
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetBusinessProcessResult.Companion.toKotlin as getBusinessProcessResultToKotlin
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetInfrastructureResourceResult.Companion.toKotlin as getInfrastructureResourceResultToKotlin
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.GetSpaceResult.Companion.toKotlin as getSpaceResultToKotlin
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.ListApplicationBusinessProcessDevelopmentArtifactsResult.Companion.toKotlin as listApplicationBusinessProcessDevelopmentArtifactsResultToKotlin

public object IntegrationspacesFunctions {
    /**
     * Get a Application
     * Azure REST API version: 2023-11-14-preview.
     * @param argument null
     * @return An integration application under space.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param applicationName The name of the Application
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spaceName The name of the space
     * @return An integration application under space.
     */
    public suspend fun getApplication(
        applicationName: String,
        resourceGroupName: String,
        spaceName: String,
    ): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            applicationName = applicationName,
            resourceGroupName = resourceGroupName,
            spaceName = spaceName,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;integrationspaces&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return An integration application under space.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit): GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * The get business process development artifact action.
     * Azure REST API version: 2023-11-14-preview.
     * @param argument null
     * @return The business process development artifact save or get response.
     */
    public suspend fun getApplicationBusinessProcessDevelopmentArtifact(argument: GetApplicationBusinessProcessDevelopmentArtifactPlainArgs): GetApplicationBusinessProcessDevelopmentArtifactResult =
        getApplicationBusinessProcessDevelopmentArtifactResultToKotlin(getApplicationBusinessProcessDevelopmentArtifactPlain(argument.toJava()).await())

    /**
     * @see [getApplicationBusinessProcessDevelopmentArtifact].
     * @param applicationName The name of the Application
     * @param name The name of the business process development artifact.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spaceName The name of the space
     * @return The business process development artifact save or get response.
     */
    public suspend fun getApplicationBusinessProcessDevelopmentArtifact(
        applicationName: String,
        name: String,
        resourceGroupName: String,
        spaceName: String,
    ): GetApplicationBusinessProcessDevelopmentArtifactResult {
        val argument = GetApplicationBusinessProcessDevelopmentArtifactPlainArgs(
            applicationName = applicationName,
            name = name,
            resourceGroupName = resourceGroupName,
            spaceName = spaceName,
        )
        return getApplicationBusinessProcessDevelopmentArtifactResultToKotlin(getApplicationBusinessProcessDevelopmentArtifactPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationBusinessProcessDevelopmentArtifact].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;integrationspaces&#46;kotlin&#46;inputs&#46;GetApplicationBusinessProcessDevelopmentArtifactPlainArgs].
     * @return The business process development artifact save or get response.
     */
    public suspend fun getApplicationBusinessProcessDevelopmentArtifact(argument: suspend GetApplicationBusinessProcessDevelopmentArtifactPlainArgsBuilder.() -> Unit): GetApplicationBusinessProcessDevelopmentArtifactResult {
        val builder = GetApplicationBusinessProcessDevelopmentArtifactPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationBusinessProcessDevelopmentArtifactResultToKotlin(getApplicationBusinessProcessDevelopmentArtifactPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a ApplicationResource
     * Azure REST API version: 2023-11-14-preview.
     * @param argument null
     * @return A resource under application.
     */
    public suspend fun getApplicationResource(argument: GetApplicationResourcePlainArgs): GetApplicationResourceResult =
        getApplicationResourceResultToKotlin(getApplicationResourcePlain(argument.toJava()).await())

    /**
     * @see [getApplicationResource].
     * @param applicationName The name of the Application
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The name of the application resource.
     * @param spaceName The name of the space
     * @return A resource under application.
     */
    public suspend fun getApplicationResource(
        applicationName: String,
        resourceGroupName: String,
        resourceName: String,
        spaceName: String,
    ): GetApplicationResourceResult {
        val argument = GetApplicationResourcePlainArgs(
            applicationName = applicationName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
            spaceName = spaceName,
        )
        return getApplicationResourceResultToKotlin(getApplicationResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;integrationspaces&#46;kotlin&#46;inputs&#46;GetApplicationResourcePlainArgs].
     * @return A resource under application.
     */
    public suspend fun getApplicationResource(argument: suspend GetApplicationResourcePlainArgsBuilder.() -> Unit): GetApplicationResourceResult {
        val builder = GetApplicationResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResourceResultToKotlin(getApplicationResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a BusinessProcess
     * Azure REST API version: 2023-11-14-preview.
     * @param argument null
     * @return A business process under application.
     */
    public suspend fun getBusinessProcess(argument: GetBusinessProcessPlainArgs): GetBusinessProcessResult =
        getBusinessProcessResultToKotlin(getBusinessProcessPlain(argument.toJava()).await())

    /**
     * @see [getBusinessProcess].
     * @param applicationName The name of the Application
     * @param businessProcessName The name of the business process
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spaceName The name of the space
     * @return A business process under application.
     */
    public suspend fun getBusinessProcess(
        applicationName: String,
        businessProcessName: String,
        resourceGroupName: String,
        spaceName: String,
    ): GetBusinessProcessResult {
        val argument = GetBusinessProcessPlainArgs(
            applicationName = applicationName,
            businessProcessName = businessProcessName,
            resourceGroupName = resourceGroupName,
            spaceName = spaceName,
        )
        return getBusinessProcessResultToKotlin(getBusinessProcessPlain(argument.toJava()).await())
    }

    /**
     * @see [getBusinessProcess].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;integrationspaces&#46;kotlin&#46;inputs&#46;GetBusinessProcessPlainArgs].
     * @return A business process under application.
     */
    public suspend fun getBusinessProcess(argument: suspend GetBusinessProcessPlainArgsBuilder.() -> Unit): GetBusinessProcessResult {
        val builder = GetBusinessProcessPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBusinessProcessResultToKotlin(getBusinessProcessPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a InfrastructureResource
     * Azure REST API version: 2023-11-14-preview.
     * @param argument null
     * @return An infrastructure resource under Space.
     */
    public suspend fun getInfrastructureResource(argument: GetInfrastructureResourcePlainArgs): GetInfrastructureResourceResult =
        getInfrastructureResourceResultToKotlin(getInfrastructureResourcePlain(argument.toJava()).await())

    /**
     * @see [getInfrastructureResource].
     * @param infrastructureResourceName The name of the infrastructure resource in the space.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spaceName The name of the space
     * @return An infrastructure resource under Space.
     */
    public suspend fun getInfrastructureResource(
        infrastructureResourceName: String,
        resourceGroupName: String,
        spaceName: String,
    ): GetInfrastructureResourceResult {
        val argument = GetInfrastructureResourcePlainArgs(
            infrastructureResourceName = infrastructureResourceName,
            resourceGroupName = resourceGroupName,
            spaceName = spaceName,
        )
        return getInfrastructureResourceResultToKotlin(getInfrastructureResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getInfrastructureResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;integrationspaces&#46;kotlin&#46;inputs&#46;GetInfrastructureResourcePlainArgs].
     * @return An infrastructure resource under Space.
     */
    public suspend fun getInfrastructureResource(argument: suspend GetInfrastructureResourcePlainArgsBuilder.() -> Unit): GetInfrastructureResourceResult {
        val builder = GetInfrastructureResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInfrastructureResourceResultToKotlin(getInfrastructureResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Space
     * Azure REST API version: 2023-11-14-preview.
     * @param argument null
     * @return An integration space.
     */
    public suspend fun getSpace(argument: GetSpacePlainArgs): GetSpaceResult =
        getSpaceResultToKotlin(getSpacePlain(argument.toJava()).await())

    /**
     * @see [getSpace].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spaceName The name of the space
     * @return An integration space.
     */
    public suspend fun getSpace(resourceGroupName: String, spaceName: String): GetSpaceResult {
        val argument = GetSpacePlainArgs(
            resourceGroupName = resourceGroupName,
            spaceName = spaceName,
        )
        return getSpaceResultToKotlin(getSpacePlain(argument.toJava()).await())
    }

    /**
     * @see [getSpace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;integrationspaces&#46;kotlin&#46;inputs&#46;GetSpacePlainArgs].
     * @return An integration space.
     */
    public suspend fun getSpace(argument: suspend GetSpacePlainArgsBuilder.() -> Unit): GetSpaceResult {
        val builder = GetSpacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSpaceResultToKotlin(getSpacePlain(builtArgument.toJava()).await())
    }

    /**
     * The list business process development artifacts action.
     * Azure REST API version: 2023-11-14-preview.
     * @param argument null
     * @return The business process development artifact get collection response.
     */
    public suspend fun listApplicationBusinessProcessDevelopmentArtifacts(argument: ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs): ListApplicationBusinessProcessDevelopmentArtifactsResult =
        listApplicationBusinessProcessDevelopmentArtifactsResultToKotlin(listApplicationBusinessProcessDevelopmentArtifactsPlain(argument.toJava()).await())

    /**
     * @see [listApplicationBusinessProcessDevelopmentArtifacts].
     * @param applicationName The name of the Application
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param spaceName The name of the space
     * @return The business process development artifact get collection response.
     */
    public suspend fun listApplicationBusinessProcessDevelopmentArtifacts(
        applicationName: String,
        resourceGroupName: String,
        spaceName: String,
    ): ListApplicationBusinessProcessDevelopmentArtifactsResult {
        val argument = ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs(
            applicationName = applicationName,
            resourceGroupName = resourceGroupName,
            spaceName = spaceName,
        )
        return listApplicationBusinessProcessDevelopmentArtifactsResultToKotlin(listApplicationBusinessProcessDevelopmentArtifactsPlain(argument.toJava()).await())
    }

    /**
     * @see [listApplicationBusinessProcessDevelopmentArtifacts].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;integrationspaces&#46;kotlin&#46;inputs&#46;ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs].
     * @return The business process development artifact get collection response.
     */
    public suspend fun listApplicationBusinessProcessDevelopmentArtifacts(argument: suspend ListApplicationBusinessProcessDevelopmentArtifactsPlainArgsBuilder.() -> Unit): ListApplicationBusinessProcessDevelopmentArtifactsResult {
        val builder = ListApplicationBusinessProcessDevelopmentArtifactsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listApplicationBusinessProcessDevelopmentArtifactsResultToKotlin(listApplicationBusinessProcessDevelopmentArtifactsPlain(builtArgument.toJava()).await())
    }
}
