@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin

import com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Space].
 */
@PulumiTagMarker
public class SpaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpaceArgs = SpaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpaceArgsBuilder.() -> Unit) {
        val builder = SpaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Space {
        val builtJavaResource = com.pulumi.azurenative.integrationspaces.Space(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Space(builtJavaResource)
    }
}

/**
 * An integration space.
 * Azure REST API version: 2023-11-14-preview.
 * ## Example Usage
 * ### CreateOrUpdateSpace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var space = new AzureNative.IntegrationSpaces.Space("space", new()
 *     {
 *         Description = "This is the user provided description of the space resource.",
 *         Location = "CentralUS",
 *         ResourceGroupName = "testrg",
 *         SpaceName = "Space1",
 *         Tags =
 *         {
 *             { "key1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/integrationspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := integrationspaces.NewSpace(ctx, "space", &integrationspaces.SpaceArgs{
 * 			Description:       pulumi.String("This is the user provided description of the space resource."),
 * 			Location:          pulumi.String("CentralUS"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			SpaceName:         pulumi.String("Space1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.integrationspaces.Space;
 * import com.pulumi.azurenative.integrationspaces.SpaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var space = new Space("space", SpaceArgs.builder()
 *             .description("This is the user provided description of the space resource.")
 *             .location("CentralUS")
 *             .resourceGroupName("testrg")
 *             .spaceName("Space1")
 *             .tags(Map.of("key1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:integrationspaces:Space Space1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}
 * ```
 */
public class Space internal constructor(
    override val javaResource: com.pulumi.azurenative.integrationspaces.Space,
) : KotlinCustomResource(javaResource, SpaceMapper) {
    /**
     * The description of the resource.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SpaceMapper : ResourceMapper<Space> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.integrationspaces.Space::class == javaResource::class

    override fun map(javaResource: Resource): Space = Space(
        javaResource as
            com.pulumi.azurenative.integrationspaces.Space,
    )
}

/**
 * @see [Space].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Space].
 */
public suspend fun space(name: String, block: suspend SpaceResourceBuilder.() -> Unit): Space {
    val builder = SpaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Space].
 * @param name The _unique_ name of the resulting resource.
 */
public fun space(name: String): Space {
    val builder = SpaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
