@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin

import com.pulumi.azurenative.integrationspaces.SpaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An integration space.
 * Azure REST API version: 2023-11-14-preview.
 * ## Example Usage
 * ### CreateOrUpdateSpace
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var space = new AzureNative.IntegrationSpaces.Space("space", new()
 *     {
 *         Description = "This is the user provided description of the space resource.",
 *         Location = "CentralUS",
 *         ResourceGroupName = "testrg",
 *         SpaceName = "Space1",
 *         Tags =
 *         {
 *             { "key1", "Value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/integrationspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := integrationspaces.NewSpace(ctx, "space", &integrationspaces.SpaceArgs{
 * 			Description:       pulumi.String("This is the user provided description of the space resource."),
 * 			Location:          pulumi.String("CentralUS"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			SpaceName:         pulumi.String("Space1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("Value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.integrationspaces.Space;
 * import com.pulumi.azurenative.integrationspaces.SpaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var space = new Space("space", SpaceArgs.builder()
 *             .description("This is the user provided description of the space resource.")
 *             .location("CentralUS")
 *             .resourceGroupName("testrg")
 *             .spaceName("Space1")
 *             .tags(Map.of("key1", "Value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:integrationspaces:Space Space1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}
 * ```
 * @property description The description of the resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spaceName The name of the space
 * @property tags Resource tags.
 */
public data class SpaceArgs(
    public val description: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val spaceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.SpaceArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.SpaceArgs =
        com.pulumi.azurenative.integrationspaces.SpaceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SpaceArgs].
 */
@PulumiTagMarker
public class SpaceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var spaceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the resource.
     */
    @JvmName("utrstukcngitrfie")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tqyidmctdmtgmiok")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eujhdnykdbjrwotu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the space
     */
    @JvmName("ivkiqrstpjblgobt")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mtlmnwferjkycffn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("wnxxdqtcdthgwfuf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fjrmswebyccnjwpk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lsmeejbdcokqbews")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("lukwqvwlragnrbwx")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("odjgugbdaeaotrcp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jisblyhxkmgtcdsx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SpaceArgs = SpaceArgs(
        description = description,
        location = location,
        resourceGroupName = resourceGroupName,
        spaceName = spaceName,
        tags = tags,
    )
}
