@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.inputs

import com.pulumi.azurenative.integrationspaces.inputs.ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The name of the Application
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spaceName The name of the space
 */
public data class ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs(
    public val applicationName: String,
    public val resourceGroupName: String,
    public val spaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.integrationspaces.inputs.ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.inputs.ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs =
        com.pulumi.azurenative.integrationspaces.inputs.ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .spaceName(spaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs].
 */
@PulumiTagMarker
public class ListApplicationBusinessProcessDevelopmentArtifactsPlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var resourceGroupName: String? = null

    private var spaceName: String? = null

    /**
     * @param value The name of the Application
     */
    @JvmName("bxflebuvlduarfll")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eefhyrsjsfgfbakv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("leokuwpwjtvuqfha")
    public suspend fun spaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.spaceName = mapped
    }

    internal fun build(): ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs =
        ListApplicationBusinessProcessDevelopmentArtifactsPlainArgs(
            applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            spaceName = spaceName ?: throw PulumiNullFieldException("spaceName"),
        )
}
