@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of business process identifier.
 * @property propertyName The property name of the business process identifier.
 * @property propertyType The property type of the business process identifier.
 */
public data class BusinessProcessIdentifierResponse(
    public val propertyName: String? = null,
    public val propertyType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.BusinessProcessIdentifierResponse): BusinessProcessIdentifierResponse = BusinessProcessIdentifierResponse(
            propertyName = javaType.propertyName().map({ args0 -> args0 }).orElse(null),
            propertyType = javaType.propertyType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
