@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The workflow tracking definition.
 * @property correlationContext The tracking correlation context.
 * @property events The tracking events.
 */
public data class FlowTrackingDefinitionResponse(
    public val correlationContext: TrackingCorrelationContextResponse? = null,
    public val events: Map<String, TrackingEventDefinitionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.FlowTrackingDefinitionResponse): FlowTrackingDefinitionResponse = FlowTrackingDefinitionResponse(
            correlationContext = javaType.correlationContext().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.integrationspaces.kotlin.outputs.TrackingCorrelationContextResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            events = javaType.events().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.integrationspaces.kotlin.outputs.TrackingEventDefinitionResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
