@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The business process development artifact save or get response.
 * @property name The name of the business process development artifact.
 * @property properties The properties of the business process development artifact.
 * @property systemData The system data of the business process development artifact.
 */
public data class GetApplicationBusinessProcessDevelopmentArtifactResult(
    public val name: String,
    public val properties: BusinessProcessDevelopmentArtifactPropertiesResponse,
    public val systemData: SystemDataResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.GetApplicationBusinessProcessDevelopmentArtifactResult): GetApplicationBusinessProcessDevelopmentArtifactResult =
            GetApplicationBusinessProcessDevelopmentArtifactResult(
                name = javaType.name(),
                properties = javaType.properties().let({ args0 ->
                    com.pulumi.azurenative.integrationspaces.kotlin.outputs.BusinessProcessDevelopmentArtifactPropertiesResponse.Companion.toKotlin(args0)
                }),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
