@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * An integration application under space.
 * @property description The description of the resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property trackingDataStores The tracking data stores.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetApplicationResult(
    public val description: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val trackingDataStores: Map<String, TrackingDataStoreResponse>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.GetApplicationResult): GetApplicationResult = GetApplicationResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            trackingDataStores = javaType.trackingDataStores().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.integrationspaces.kotlin.outputs.TrackingDataStoreResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            type = javaType.type(),
        )
    }
}
