@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A business process under application.
 * @property businessProcessMapping The business process mapping.
 * @property businessProcessStages The business process stages.
 * @property description The description of the business process.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identifier The business process identifier.
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tableName The table name of the business process.
 * @property trackingDataStoreReferenceName The tracking data store reference name.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version The version of the business process.
 */
public data class GetBusinessProcessResult(
    public val businessProcessMapping: Map<String, BusinessProcessMappingItemResponse>? = null,
    public val businessProcessStages: Map<String, BusinessProcessStageResponse>? = null,
    public val description: String? = null,
    public val id: String,
    public val identifier: BusinessProcessIdentifierResponse? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tableName: String? = null,
    public val trackingDataStoreReferenceName: String? = null,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.GetBusinessProcessResult): GetBusinessProcessResult = GetBusinessProcessResult(
            businessProcessMapping = javaType.businessProcessMapping().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.integrationspaces.kotlin.outputs.BusinessProcessMappingItemResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            businessProcessStages = javaType.businessProcessStages().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.integrationspaces.kotlin.outputs.BusinessProcessStageResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identifier = javaType.identifier().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.integrationspaces.kotlin.outputs.BusinessProcessIdentifierResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tableName = javaType.tableName().map({ args0 -> args0 }).orElse(null),
            trackingDataStoreReferenceName = javaType.trackingDataStoreReferenceName().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
