@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The business process development artifact save or get response.
 * @property name The name of the business process development artifact.
 * @property properties The properties of the business process development artifact.
 * @property systemData The system data of the business process development artifact.
 */
public data class SaveOrGetBusinessProcessDevelopmentArtifactResponseResponse(
    public val name: String,
    public val properties: BusinessProcessDevelopmentArtifactPropertiesResponse? = null,
    public val systemData: SystemDataResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.SaveOrGetBusinessProcessDevelopmentArtifactResponseResponse): SaveOrGetBusinessProcessDevelopmentArtifactResponseResponse =
            SaveOrGetBusinessProcessDevelopmentArtifactResponseResponse(
                name = javaType.name(),
                properties = javaType.properties().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.integrationspaces.kotlin.outputs.BusinessProcessDevelopmentArtifactPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
            )
    }
}
