@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of tracking data store.
 * @property dataStoreIngestionUri The data store ingestion URI.
 * @property dataStoreResourceId The data store resource id.
 * @property dataStoreUri The data store URI.
 * @property databaseName The database name.
 */
public data class TrackingDataStoreResponse(
    public val dataStoreIngestionUri: String? = null,
    public val dataStoreResourceId: String? = null,
    public val dataStoreUri: String? = null,
    public val databaseName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.integrationspaces.outputs.TrackingDataStoreResponse): TrackingDataStoreResponse = TrackingDataStoreResponse(
            dataStoreIngestionUri = javaType.dataStoreIngestionUri().map({ args0 -> args0 }).orElse(null),
            dataStoreResourceId = javaType.dataStoreResourceId().map({ args0 -> args0 }).orElse(null),
            dataStoreUri = javaType.dataStoreUri().map({ args0 -> args0 }).orElse(null),
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
