@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.intune.kotlin.inputs

import com.pulumi.azurenative.intune.inputs.GetAndroidMAMPolicyByNamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostName Location hostName for the tenant
 * @property policyName Unique name for the policy
 * @property select select specific fields in entity.
 */
public data class GetAndroidMAMPolicyByNamePlainArgs(
    public val hostName: String,
    public val policyName: String,
    public val select: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.intune.inputs.GetAndroidMAMPolicyByNamePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.intune.inputs.GetAndroidMAMPolicyByNamePlainArgs =
        com.pulumi.azurenative.intune.inputs.GetAndroidMAMPolicyByNamePlainArgs.builder()
            .hostName(hostName.let({ args0 -> args0 }))
            .policyName(policyName.let({ args0 -> args0 }))
            .select(select?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAndroidMAMPolicyByNamePlainArgs].
 */
@PulumiTagMarker
public class GetAndroidMAMPolicyByNamePlainArgsBuilder internal constructor() {
    private var hostName: String? = null

    private var policyName: String? = null

    private var select: String? = null

    /**
     * @param value Location hostName for the tenant
     */
    @JvmName("bipkcinxywopvpqw")
    public suspend fun hostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostName = mapped
    }

    /**
     * @param value Unique name for the policy
     */
    @JvmName("uyuyykrolhpgnxrd")
    public suspend fun policyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyName = mapped
    }

    /**
     * @param value select specific fields in entity.
     */
    @JvmName("rfgvbbiffhgjjpog")
    public suspend fun select(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.select = mapped
    }

    internal fun build(): GetAndroidMAMPolicyByNamePlainArgs = GetAndroidMAMPolicyByNamePlainArgs(
        hostName = hostName ?: throw PulumiNullFieldException("hostName"),
        policyName = policyName ?: throw PulumiNullFieldException("policyName"),
        select = select,
    )
}
