@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotcentral.kotlin

import com.pulumi.azurenative.iotcentral.kotlin.outputs.AppSkuInfoResponse
import com.pulumi.azurenative.iotcentral.kotlin.outputs.SystemAssignedServiceIdentityResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotcentral.kotlin.outputs.AppSkuInfoResponse.Companion.toKotlin as appSkuInfoResponseToKotlin
import com.pulumi.azurenative.iotcentral.kotlin.outputs.SystemAssignedServiceIdentityResponse.Companion.toKotlin as systemAssignedServiceIdentityResponseToKotlin

/**
 * Builder for [App].
 */
@PulumiTagMarker
public class AppResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppArgs = AppArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppArgsBuilder.() -> Unit) {
        val builder = AppArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): App {
        val builtJavaResource = com.pulumi.azurenative.iotcentral.App(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return App(builtJavaResource)
    }
}

/**
 * The IoT Central application.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * Other available API versions: 2018-09-01, 2021-11-01-preview.
 * ## Example Usage
 * ### Apps_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var app = new AzureNative.IoTCentral.App("app", new()
 *     {
 *         DisplayName = "My IoT Central App",
 *         Identity = new AzureNative.IoTCentral.Inputs.SystemAssignedServiceIdentityArgs
 *         {
 *             Type = AzureNative.IoTCentral.SystemAssignedServiceIdentityType.SystemAssigned,
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myIoTCentralApp",
 *         Sku = new AzureNative.IoTCentral.Inputs.AppSkuInfoArgs
 *         {
 *             Name = AzureNative.IoTCentral.AppSku.ST2,
 *         },
 *         Subdomain = "my-iot-central-app",
 *         Template = "iotc-pnp-preview@1.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotcentral/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotcentral.NewApp(ctx, "app", &iotcentral.AppArgs{
 * 			DisplayName: pulumi.String("My IoT Central App"),
 * 			Identity: &iotcentral.SystemAssignedServiceIdentityArgs{
 * 				Type: pulumi.String(iotcentral.SystemAssignedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myIoTCentralApp"),
 * 			Sku: &iotcentral.AppSkuInfoArgs{
 * 				Name: pulumi.String(iotcentral.AppSkuST2),
 * 			},
 * 			Subdomain: pulumi.String("my-iot-central-app"),
 * 			Template:  pulumi.String("iotc-pnp-preview@1.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotcentral.App;
 * import com.pulumi.azurenative.iotcentral.AppArgs;
 * import com.pulumi.azurenative.iotcentral.inputs.SystemAssignedServiceIdentityArgs;
 * import com.pulumi.azurenative.iotcentral.inputs.AppSkuInfoArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app", AppArgs.builder()
 *             .displayName("My IoT Central App")
 *             .identity(SystemAssignedServiceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("westus")
 *             .resourceGroupName("resRg")
 *             .resourceName("myIoTCentralApp")
 *             .sku(AppSkuInfoArgs.builder()
 *                 .name("ST2")
 *                 .build())
 *             .subdomain("my-iot-central-app")
 *             .template("iotc-pnp-preview@1.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotcentral:App myIoTCentralApp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTCentral/iotApps/{resourceName}
 * ```
 */
public class App internal constructor(
    override val javaResource: com.pulumi.azurenative.iotcentral.App,
) : KotlinCustomResource(javaResource, AppMapper) {
    /**
     * The ID of the application.
     */
    public val applicationId: Output<String>
        get() = javaResource.applicationId().applyValue({ args0 -> args0 })

    /**
     * The display name of the application.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The managed identities for the IoT Central application.
     */
    public val identity: Output<SystemAssignedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    systemAssignedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The ARM resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A valid instance SKU.
     */
    public val sku: Output<AppSkuInfoResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                appSkuInfoResponseToKotlin(args0)
            })
        })

    /**
     * The current state of the application.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The subdomain of the application.
     */
    public val subdomain: Output<String>?
        get() = javaResource.subdomain().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the application template, which is a blueprint that defines the characteristics and behaviors of an application. Optional; if not specified, defaults to a blank blueprint and allows the application to be defined from scratch.
     */
    public val template: Output<String>?
        get() = javaResource.template().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AppMapper : ResourceMapper<App> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotcentral.App::class == javaResource::class

    override fun map(javaResource: Resource): App = App(
        javaResource as
            com.pulumi.azurenative.iotcentral.App,
    )
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [App].
 */
public suspend fun app(name: String, block: suspend AppResourceBuilder.() -> Unit): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [App].
 * @param name The _unique_ name of the resulting resource.
 */
public fun app(name: String): App {
    val builder = AppResourceBuilder()
    builder.name(name)
    return builder.build()
}
