@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotcentral.kotlin.inputs

import com.pulumi.azurenative.iotcentral.inputs.AppSkuInfoArgs.builder
import com.pulumi.azurenative.iotcentral.kotlin.enums.AppSku
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information about the SKU of the IoT Central application.
 * @property name The name of the SKU.
 */
public data class AppSkuInfoArgs(
    public val name: Output<Either<String, AppSku>>,
) : ConvertibleToJava<com.pulumi.azurenative.iotcentral.inputs.AppSkuInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.iotcentral.inputs.AppSkuInfoArgs =
        com.pulumi.azurenative.iotcentral.inputs.AppSkuInfoArgs.builder()
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AppSkuInfoArgs].
 */
@PulumiTagMarker
public class AppSkuInfoArgsBuilder internal constructor() {
    private var name: Output<Either<String, AppSku>>? = null

    /**
     * @param value The name of the SKU.
     */
    @JvmName("slcivaaefilfkxey")
    public suspend fun name(`value`: Output<Either<String, AppSku>>) {
        this.name = value
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("giaweognplbcxamp")
    public suspend fun name(`value`: Either<String, AppSku>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("ynphonpvuxaqghsp")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AppSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("sspitkbdfsqjpprf")
    public fun name(`value`: AppSku) {
        val toBeMapped = Either.ofRight<String, AppSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AppSkuInfoArgs = AppSkuInfoArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
