@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotcentral.kotlin.inputs

import com.pulumi.azurenative.iotcentral.inputs.GetAppPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the IoT Central application.
 * @property resourceName The ARM resource name of the IoT Central application.
 */
public data class GetAppPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotcentral.inputs.GetAppPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotcentral.inputs.GetAppPlainArgs =
        com.pulumi.azurenative.iotcentral.inputs.GetAppPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppPlainArgs].
 */
@PulumiTagMarker
public class GetAppPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group that contains the IoT Central application.
     */
    @JvmName("tjmvglnmclerqnuq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ARM resource name of the IoT Central application.
     */
    @JvmName("vffppgmjsfckscsg")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetAppPlainArgs = GetAppPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
