@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotcentral.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The IoT Central application.
 * @property applicationId The ID of the application.
 * @property displayName The display name of the application.
 * @property id The ARM resource identifier.
 * @property identity The managed identities for the IoT Central application.
 * @property location The resource location.
 * @property name The ARM resource name.
 * @property sku A valid instance SKU.
 * @property state The current state of the application.
 * @property subdomain The subdomain of the application.
 * @property tags The resource tags.
 * @property template The ID of the application template, which is a blueprint that defines the characteristics and behaviors of an application. Optional; if not specified, defaults to a blank blueprint and allows the application to be defined from scratch.
 * @property type The resource type.
 */
public data class GetAppResult(
    public val applicationId: String,
    public val displayName: String? = null,
    public val id: String,
    public val identity: SystemAssignedServiceIdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val sku: AppSkuInfoResponse,
    public val state: String,
    public val subdomain: String? = null,
    public val tags: Map<String, String>? = null,
    public val template: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotcentral.outputs.GetAppResult): GetAppResult = GetAppResult(
            applicationId = javaType.applicationId(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotcentral.kotlin.outputs.SystemAssignedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.iotcentral.kotlin.outputs.AppSkuInfoResponse.Companion.toKotlin(args0)
            }),
            state = javaType.state(),
            subdomain = javaType.subdomain().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            template = javaType.template().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
