@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotcentral.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed service identity (either system assigned, or none)
 * @property principalId The service principal ID of the system assigned identity. This property will only be provided for a system assigned identity.
 * @property tenantId The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
 * @property type Type of managed service identity (either system assigned, or none).
 */
public data class SystemAssignedServiceIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotcentral.outputs.SystemAssignedServiceIdentityResponse): SystemAssignedServiceIdentityResponse = SystemAssignedServiceIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
