@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotfirmwaredefense.kotlin

import com.pulumi.azurenative.iotfirmwaredefense.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.iotfirmwaredefense.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Firmware].
 */
@PulumiTagMarker
public class FirmwareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirmwareArgs = FirmwareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirmwareArgsBuilder.() -> Unit) {
        val builder = FirmwareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Firmware {
        val builtJavaResource =
            com.pulumi.azurenative.iotfirmwaredefense.Firmware(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Firmware(builtJavaResource)
    }
}

/**
 * Firmware definition
 * Azure REST API version: 2023-02-08-preview.
 * Other available API versions: 2024-01-10.
 * ## Example Usage
 * ### Firmware_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firmware = new AzureNative.IoTFirmwareDefense.Firmware("firmware", new()
 *     {
 *         Description = "uz",
 *         FileName = "wresexxulcdsdd",
 *         FileSize = 17,
 *         FirmwareId = "umrkdttp",
 *         Model = "f",
 *         ResourceGroupName = "rgworkspaces-firmwares",
 *         Status = AzureNative.IoTFirmwareDefense.Status.Pending,
 *         StatusMessages = new[]
 *         {
 *             new Dictionary<string, object?>
 *             {
 *                 ["message"] = "ulvhmhokezathzzauiitu",
 *             },
 *         },
 *         Vendor = "vycmdhgtmepcptyoubztiuudpkcpd",
 *         Version = "s",
 *         WorkspaceName = "A7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotfirmwaredefense/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotfirmwaredefense.NewFirmware(ctx, "firmware", &iotfirmwaredefense.FirmwareArgs{
 * 			Description:       pulumi.String("uz"),
 * 			FileName:          pulumi.String("wresexxulcdsdd"),
 * 			FileSize:          pulumi.Float64(17),
 * 			FirmwareId:        pulumi.String("umrkdttp"),
 * 			Model:             pulumi.String("f"),
 * 			ResourceGroupName: pulumi.String("rgworkspaces-firmwares"),
 * 			Status:            pulumi.String(iotfirmwaredefense.StatusPending),
 * 			StatusMessages: pulumi.Array{
 * 				pulumi.Any(map[string]interface{}{
 * 					"message": "ulvhmhokezathzzauiitu",
 * 				}),
 * 			},
 * 			Vendor:        pulumi.String("vycmdhgtmepcptyoubztiuudpkcpd"),
 * 			Version:       pulumi.String("s"),
 * 			WorkspaceName: pulumi.String("A7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotfirmwaredefense.Firmware;
 * import com.pulumi.azurenative.iotfirmwaredefense.FirmwareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firmware = new Firmware("firmware", FirmwareArgs.builder()
 *             .description("uz")
 *             .fileName("wresexxulcdsdd")
 *             .fileSize(17)
 *             .firmwareId("umrkdttp")
 *             .model("f")
 *             .resourceGroupName("rgworkspaces-firmwares")
 *             .status("Pending")
 *             .statusMessages(Map.of("message", "ulvhmhokezathzzauiitu"))
 *             .vendor("vycmdhgtmepcptyoubztiuudpkcpd")
 *             .version("s")
 *             .workspaceName("A7")
 *             .build());
 *     }
 * }
 * ```
 * ### Firmware_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firmware = new AzureNative.IoTFirmwareDefense.Firmware("firmware", new()
 *     {
 *         FirmwareId = "umrkdttp",
 *         ResourceGroupName = "rgworkspaces-firmwares",
 *         WorkspaceName = "A7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotfirmwaredefense/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotfirmwaredefense.NewFirmware(ctx, "firmware", &iotfirmwaredefense.FirmwareArgs{
 * 			FirmwareId:        pulumi.String("umrkdttp"),
 * 			ResourceGroupName: pulumi.String("rgworkspaces-firmwares"),
 * 			WorkspaceName:     pulumi.String("A7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotfirmwaredefense.Firmware;
 * import com.pulumi.azurenative.iotfirmwaredefense.FirmwareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firmware = new Firmware("firmware", FirmwareArgs.builder()
 *             .firmwareId("umrkdttp")
 *             .resourceGroupName("rgworkspaces-firmwares")
 *             .workspaceName("A7")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotfirmwaredefense:Firmware brmvnojpmxsgckdviynhxhftvcvbw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTFirmwareDefense/workspaces/{workspaceName}/firmwares/{firmwareId}
 * ```
 */
public class Firmware internal constructor(
    override val javaResource: com.pulumi.azurenative.iotfirmwaredefense.Firmware,
) : KotlinCustomResource(javaResource, FirmwareMapper) {
    /**
     * User-specified description of the firmware.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * File name for a firmware that user uploaded.
     */
    public val fileName: Output<String>?
        get() = javaResource.fileName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * File size of the uploaded firmware image.
     */
    public val fileSize: Output<Double>?
        get() = javaResource.fileSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Firmware model.
     */
    public val model: Output<String>?
        get() = javaResource.model().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The status of firmware scan.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of errors or other messages generated during firmware analysis
     */
    public val statusMessages: Output<List<Any>>?
        get() = javaResource.statusMessages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Firmware vendor.
     */
    public val vendor: Output<String>?
        get() = javaResource.vendor().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Firmware version.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object FirmwareMapper : ResourceMapper<Firmware> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotfirmwaredefense.Firmware::class == javaResource::class

    override fun map(javaResource: Resource): Firmware = Firmware(
        javaResource as
            com.pulumi.azurenative.iotfirmwaredefense.Firmware,
    )
}

/**
 * @see [Firmware].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Firmware].
 */
public suspend fun firmware(name: String, block: suspend FirmwareResourceBuilder.() -> Unit): Firmware {
    val builder = FirmwareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Firmware].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firmware(name: String): Firmware {
    val builder = FirmwareResourceBuilder()
    builder.name(name)
    return builder.build()
}
