@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotfirmwaredefense.kotlin.inputs

import com.pulumi.azurenative.iotfirmwaredefense.inputs.GetWorkspacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the firmware analysis workspace.
 */
public data class GetWorkspacePlainArgs(
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotfirmwaredefense.inputs.GetWorkspacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotfirmwaredefense.inputs.GetWorkspacePlainArgs =
        com.pulumi.azurenative.iotfirmwaredefense.inputs.GetWorkspacePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspacePlainArgs].
 */
@PulumiTagMarker
public class GetWorkspacePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tkmtwajrmtwtauau")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the firmware analysis workspace.
     */
    @JvmName("mjmyuoscbeliplvt")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetWorkspacePlainArgs = GetWorkspacePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
