@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotfirmwaredefense.kotlin.outputs

import kotlin.Any
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Firmware definition
 * @property description User-specified description of the firmware.
 * @property fileName File name for a firmware that user uploaded.
 * @property fileSize File size of the uploaded firmware image.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property model Firmware model.
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the resource.
 * @property status The status of firmware scan.
 * @property statusMessages A list of errors or other messages generated during firmware analysis
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vendor Firmware vendor.
 * @property version Firmware version.
 */
public data class GetFirmwareResult(
    public val description: String? = null,
    public val fileName: String? = null,
    public val fileSize: Double? = null,
    public val id: String,
    public val model: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val status: String? = null,
    public val statusMessages: List<Any>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val vendor: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotfirmwaredefense.outputs.GetFirmwareResult): GetFirmwareResult = GetFirmwareResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            fileName = javaType.fileName().map({ args0 -> args0 }).orElse(null),
            fileSize = javaType.fileSize().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            model = javaType.model().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            statusMessages = javaType.statusMessages().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotfirmwaredefense.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            vendor = javaType.vendor().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
