@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin

import com.pulumi.azurenative.iotoperationsdataprocessor.DatasetArgs.builder
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.DatasetPropertyKeyArgs
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.DatasetPropertyKeyArgsBuilder
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Dataset resource belonging to an Instance resource.
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Datasets create or update - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataset = new AzureNative.IoTOperationsDataProcessor.Dataset("dataset", new()
 *     {
 *         DatasetName = "709v7-95-5-t-52oc5--s-5-5876j45wp6mf6--n-8bh--l55-r477",
 *         Description = "pakdvhh",
 *         ExtendedLocation = new AzureNative.IoTOperationsDataProcessor.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space",
 *             Type = "CustomLocation",
 *         },
 *         InstanceName = "xh--6h732-2-6-21-4513-2-597q-5412971q",
 *         Keys = null,
 *         Location = "westus",
 *         Payload = ".value",
 *         ResourceGroupName = "rgopenapi",
 *         Tags = null,
 *         Timestamp = ".timestamp",
 *         Ttl = "72h",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsdataprocessor/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsdataprocessor.NewDataset(ctx, "dataset", &iotoperationsdataprocessor.DatasetArgs{
 * 			DatasetName: pulumi.String("709v7-95-5-t-52oc5--s-5-5876j45wp6mf6--n-8bh--l55-r477"),
 * 			Description: pulumi.String("pakdvhh"),
 * 			ExtendedLocation: &iotoperationsdataprocessor.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			InstanceName:      pulumi.String("xh--6h732-2-6-21-4513-2-597q-5412971q"),
 * 			Keys:              nil,
 * 			Location:          pulumi.String("westus"),
 * 			Payload:           pulumi.String(".value"),
 * 			ResourceGroupName: pulumi.String("rgopenapi"),
 * 			Tags:              nil,
 * 			Timestamp:         pulumi.String(".timestamp"),
 * 			Ttl:               pulumi.String("72h"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.Dataset;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.DatasetArgs;
 * import com.pulumi.azurenative.iotoperationsdataprocessor.inputs.ExtendedLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataset = new Dataset("dataset", DatasetArgs.builder()
 *             .datasetName("709v7-95-5-t-52oc5--s-5-5876j45wp6mf6--n-8bh--l55-r477")
 *             .description("pakdvhh")
 *             .extendedLocation(ExtendedLocationArgs.builder()
 *                 .name("/subscriptions/e0aaa3df-e9a4-456a-9824-3c3b5c438110/resourceGroups/IoTOperationsDataProcessor-rg/providers/Microsoft.ExtendedLocation/customLocations/dev-space")
 *                 .type("CustomLocation")
 *                 .build())
 *             .instanceName("xh--6h732-2-6-21-4513-2-597q-5412971q")
 *             .keys()
 *             .location("westus")
 *             .payload(".value")
 *             .resourceGroupName("rgopenapi")
 *             .tags()
 *             .timestamp(".timestamp")
 *             .ttl("72h")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsdataprocessor:Dataset IoTOperationsDataProcessor-dataset-name /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsDataProcessor/instances/{instanceName}/datasets/{datasetName}
 * ```
 * @property datasetName Name of dataset.
 * @property description Detailed description of the Dataset.
 * @property extendedLocation Edge location of the resource.
 * @property instanceName Name of instance.
 * @property keys List of keys that can be used for joining on enrich.
 * @property location The geo-location where the resource lives
 * @property payload Path to the payload in the message. Enrich will add only the payload to the enriched message, other fields will not be kept except for in the indexes.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property timestamp Path to an RFC3339 timestamp in the message. If no path is provided, the ingestion time of the record is used for time-based joins.
 * @property ttl Time to live for individual records.
 */
public data class DatasetArgs(
    public val datasetName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val instanceName: Output<String>? = null,
    public val keys: Output<Map<String, DatasetPropertyKeyArgs>>? = null,
    public val location: Output<String>? = null,
    public val payload: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timestamp: Output<String>? = null,
    public val ttl: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.DatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsdataprocessor.DatasetArgs =
        com.pulumi.azurenative.iotoperationsdataprocessor.DatasetArgs.builder()
            .datasetName(datasetName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .keys(
                keys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.let({ args0 ->
                                args0.toJava()
                            }),
                        )
                    }).toMap()
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .payload(payload?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timestamp(timestamp?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetArgs].
 */
@PulumiTagMarker
public class DatasetArgsBuilder internal constructor() {
    private var datasetName: Output<String>? = null

    private var description: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var instanceName: Output<String>? = null

    private var keys: Output<Map<String, DatasetPropertyKeyArgs>>? = null

    private var location: Output<String>? = null

    private var payload: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timestamp: Output<String>? = null

    private var ttl: Output<String>? = null

    /**
     * @param value Name of dataset.
     */
    @JvmName("kouvmwxllxtcpnuq")
    public suspend fun datasetName(`value`: Output<String>) {
        this.datasetName = value
    }

    /**
     * @param value Detailed description of the Dataset.
     */
    @JvmName("eprxflxnxjcwcpha")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("xwojpajvmfhpjpcm")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Name of instance.
     */
    @JvmName("pdvngqnntvuqtrlo")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value List of keys that can be used for joining on enrich.
     */
    @JvmName("iuuecbxsjqtvfjbf")
    public suspend fun keys(`value`: Output<Map<String, DatasetPropertyKeyArgs>>) {
        this.keys = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dveehnyltxbmljtf")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Path to the payload in the message. Enrich will add only the payload to the enriched message, other fields will not be kept except for in the indexes.
     */
    @JvmName("wxudfoflfaujackw")
    public suspend fun payload(`value`: Output<String>) {
        this.payload = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tkjrkakisestrxly")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ddbdfsfwscsliuhs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Path to an RFC3339 timestamp in the message. If no path is provided, the ingestion time of the record is used for time-based joins.
     */
    @JvmName("honbkebqyaiflqpa")
    public suspend fun timestamp(`value`: Output<String>) {
        this.timestamp = value
    }

    /**
     * @param value Time to live for individual records.
     */
    @JvmName("elmsapjxsdobvtsg")
    public suspend fun ttl(`value`: Output<String>) {
        this.ttl = value
    }

    /**
     * @param value Name of dataset.
     */
    @JvmName("jabtgvhcdkdvbiak")
    public suspend fun datasetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasetName = mapped
    }

    /**
     * @param value Detailed description of the Dataset.
     */
    @JvmName("cestuovfqfyatfjl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Edge location of the resource.
     */
    @JvmName("xedrbyfnsskdbgri")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Edge location of the resource.
     */
    @JvmName("ontqklxvhxxnxonx")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Name of instance.
     */
    @JvmName("kwokspcydhtxvtbt")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value List of keys that can be used for joining on enrich.
     */
    @JvmName("acdmjuogigbfydqv")
    public suspend fun keys(`value`: Map<String, DatasetPropertyKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param argument List of keys that can be used for joining on enrich.
     */
    @JvmName("waucyokdkdoywhes")
    public suspend fun keys(vararg argument: Pair<String, suspend DatasetPropertyKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                DatasetPropertyKeyArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.keys = mapped
    }

    /**
     * @param values List of keys that can be used for joining on enrich.
     */
    @JvmName("jpbbcjhcjvmiuoqk")
    public fun keys(vararg values: Pair<String, DatasetPropertyKeyArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keys = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cefexelvngupkjqg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Path to the payload in the message. Enrich will add only the payload to the enriched message, other fields will not be kept except for in the indexes.
     */
    @JvmName("jguqnnofwlprostb")
    public suspend fun payload(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payload = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("smjgmugdxhuqiayf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hhvbwywlopbrpxks")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nffjstbqcfhlswlc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Path to an RFC3339 timestamp in the message. If no path is provided, the ingestion time of the record is used for time-based joins.
     */
    @JvmName("hcgmvlosygrswnhp")
    public suspend fun timestamp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timestamp = mapped
    }

    /**
     * @param value Time to live for individual records.
     */
    @JvmName("yvkveccwuqgjipjj")
    public suspend fun ttl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    internal fun build(): DatasetArgs = DatasetArgs(
        datasetName = datasetName,
        description = description,
        extendedLocation = extendedLocation,
        instanceName = instanceName,
        keys = keys,
        location = location,
        payload = payload,
        resourceGroupName = resourceGroupName,
        tags = tags,
        timestamp = timestamp,
        ttl = ttl,
    )
}
