@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin

import com.pulumi.azurenative.iotoperationsdataprocessor.IotoperationsdataprocessorFunctions.getDatasetPlain
import com.pulumi.azurenative.iotoperationsdataprocessor.IotoperationsdataprocessorFunctions.getInstancePlain
import com.pulumi.azurenative.iotoperationsdataprocessor.IotoperationsdataprocessorFunctions.getPipelinePlain
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.GetDatasetPlainArgs
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.GetDatasetPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.GetInstancePlainArgs
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.GetInstancePlainArgsBuilder
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.GetPipelinePlainArgs
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs.GetPipelinePlainArgsBuilder
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.GetDatasetResult
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.GetInstanceResult
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.GetPipelineResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.GetDatasetResult.Companion.toKotlin as getDatasetResultToKotlin
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.GetInstanceResult.Companion.toKotlin as getInstanceResultToKotlin
import com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.GetPipelineResult.Companion.toKotlin as getPipelineResultToKotlin

public object IotoperationsdataprocessorFunctions {
    /**
     * Get a Dataset
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return A Dataset resource belonging to an Instance resource.
     */
    public suspend fun getDataset(argument: GetDatasetPlainArgs): GetDatasetResult =
        getDatasetResultToKotlin(getDatasetPlain(argument.toJava()).await())

    /**
     * @see [getDataset].
     * @param datasetName Name of dataset.
     * @param instanceName Name of instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A Dataset resource belonging to an Instance resource.
     */
    public suspend fun getDataset(
        datasetName: String,
        instanceName: String,
        resourceGroupName: String,
    ): GetDatasetResult {
        val argument = GetDatasetPlainArgs(
            datasetName = datasetName,
            instanceName = instanceName,
            resourceGroupName = resourceGroupName,
        )
        return getDatasetResultToKotlin(getDatasetPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataset].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsdataprocessor&#46;kotlin&#46;inputs&#46;GetDatasetPlainArgs].
     * @return A Dataset resource belonging to an Instance resource.
     */
    public suspend fun getDataset(argument: suspend GetDatasetPlainArgsBuilder.() -> Unit): GetDatasetResult {
        val builder = GetDatasetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatasetResultToKotlin(getDatasetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Instance
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return A Instance resource is a logical container for a set of child resources.
     */
    public suspend fun getInstance(argument: GetInstancePlainArgs): GetInstanceResult =
        getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())

    /**
     * @see [getInstance].
     * @param instanceName Name of instance.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A Instance resource is a logical container for a set of child resources.
     */
    public suspend fun getInstance(instanceName: String, resourceGroupName: String): GetInstanceResult {
        val argument = GetInstancePlainArgs(
            instanceName = instanceName,
            resourceGroupName = resourceGroupName,
        )
        return getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsdataprocessor&#46;kotlin&#46;inputs&#46;GetInstancePlainArgs].
     * @return A Instance resource is a logical container for a set of child resources.
     */
    public suspend fun getInstance(argument: suspend GetInstancePlainArgsBuilder.() -> Unit): GetInstanceResult {
        val builder = GetInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceResultToKotlin(getInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Pipeline
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return A Pipeline resource belonging to an Instance resource.
     */
    public suspend fun getPipeline(argument: GetPipelinePlainArgs): GetPipelineResult =
        getPipelineResultToKotlin(getPipelinePlain(argument.toJava()).await())

    /**
     * @see [getPipeline].
     * @param instanceName Name of instance.
     * @param pipelineName Name of pipeline
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return A Pipeline resource belonging to an Instance resource.
     */
    public suspend fun getPipeline(
        instanceName: String,
        pipelineName: String,
        resourceGroupName: String,
    ): GetPipelineResult {
        val argument = GetPipelinePlainArgs(
            instanceName = instanceName,
            pipelineName = pipelineName,
            resourceGroupName = resourceGroupName,
        )
        return getPipelineResultToKotlin(getPipelinePlain(argument.toJava()).await())
    }

    /**
     * @see [getPipeline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsdataprocessor&#46;kotlin&#46;inputs&#46;GetPipelinePlainArgs].
     * @return A Pipeline resource belonging to an Instance resource.
     */
    public suspend fun getPipeline(argument: suspend GetPipelinePlainArgsBuilder.() -> Unit): GetPipelineResult {
        val builder = GetPipelinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPipelineResultToKotlin(getPipelinePlain(builtArgument.toJava()).await())
    }
}
