@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs

import com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetPipelinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceName Name of instance.
 * @property pipelineName Name of pipeline
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPipelinePlainArgs(
    public val instanceName: String,
    public val pipelineName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetPipelinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetPipelinePlainArgs =
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.GetPipelinePlainArgs.builder()
            .instanceName(instanceName.let({ args0 -> args0 }))
            .pipelineName(pipelineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelinePlainArgs].
 */
@PulumiTagMarker
public class GetPipelinePlainArgsBuilder internal constructor() {
    private var instanceName: String? = null

    private var pipelineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of instance.
     */
    @JvmName("fisdbwhebsptwgfy")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceName = mapped
    }

    /**
     * @param value Name of pipeline
     */
    @JvmName("btlirbhvlkqjnqfn")
    public suspend fun pipelineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uvonsohbgomcogso")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPipelinePlainArgs = GetPipelinePlainArgs(
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        pipelineName = pipelineName ?: throw PulumiNullFieldException("pipelineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
