@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs

import com.pulumi.azurenative.iotoperationsdataprocessor.inputs.PipelineInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Stage configuration for Pipeline input stage.
 * @property description Description for stage.
 * @property next Next stage in the pipeline.
 * @property type ARM resource type.
 */
public data class PipelineInputArgs(
    public val description: Output<String>? = null,
    public val next: Output<List<String>>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.inputs.PipelineInputArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsdataprocessor.inputs.PipelineInputArgs = com.pulumi.azurenative.iotoperationsdataprocessor.inputs.PipelineInputArgs.builder()
        .description(description?.applyValue({ args0 -> args0 }))
        .next(next.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineInputArgs].
 */
@PulumiTagMarker
public class PipelineInputArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var next: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description for stage.
     */
    @JvmName("sqwxnytujmifxxlw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Next stage in the pipeline.
     */
    @JvmName("mkcerurnackyxvth")
    public suspend fun next(`value`: Output<List<String>>) {
        this.next = value
    }

    @JvmName("pvxrmmyrndhbuxho")
    public suspend fun next(vararg values: Output<String>) {
        this.next = Output.all(values.asList())
    }

    /**
     * @param values Next stage in the pipeline.
     */
    @JvmName("pjxopbsmpicvqmfe")
    public suspend fun next(values: List<Output<String>>) {
        this.next = Output.all(values)
    }

    /**
     * @param value ARM resource type.
     */
    @JvmName("tugkjuhqsutfgmol")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description for stage.
     */
    @JvmName("fycebfirjskmuctl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Next stage in the pipeline.
     */
    @JvmName("pyhodjuhdaecbpxw")
    public suspend fun next(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.next = mapped
    }

    /**
     * @param values Next stage in the pipeline.
     */
    @JvmName("pqtiiqucnknttfgw")
    public suspend fun next(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.next = mapped
    }

    /**
     * @param value ARM resource type.
     */
    @JvmName("vrcsvsddhhjuaagf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipelineInputArgs = PipelineInputArgs(
        description = description,
        next = next ?: throw PulumiNullFieldException("next"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
