@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Key that can be used for joining on enrich.
 * @property path Path to the input value from the message.
 * @property primaryKey If true the property will be used as a primary key. At most one primary key can exists.
 */
public data class DatasetPropertyKeyResponse(
    public val path: String,
    public val primaryKey: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsdataprocessor.outputs.DatasetPropertyKeyResponse): DatasetPropertyKeyResponse = DatasetPropertyKeyResponse(
            path = javaType.path(),
            primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
