@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Extended location is an extension of Azure locations. They provide a way to use their Azure ARC enabled Kubernetes clusters as target locations for deploying Azure services instances.
 * @property name The name of the extended location.
 * @property type The type of the extended location.
 */
public data class ExtendedLocationResponse(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsdataprocessor.outputs.ExtendedLocationResponse): ExtendedLocationResponse = ExtendedLocationResponse(
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
