@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Dataset resource belonging to an Instance resource.
 * @property description Detailed description of the Dataset.
 * @property extendedLocation Edge location of the resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property keys List of keys that can be used for joining on enrich.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property payload Path to the payload in the message. Enrich will add only the payload to the enriched message, other fields will not be kept except for in the indexes.
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property timestamp Path to an RFC3339 timestamp in the message. If no path is provided, the ingestion time of the record is used for time-based joins.
 * @property ttl Time to live for individual records.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDatasetResult(
    public val description: String? = null,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val keys: Map<String, DatasetPropertyKeyResponse>? = null,
    public val location: String,
    public val name: String,
    public val payload: String? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val timestamp: String? = null,
    public val ttl: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsdataprocessor.outputs.GetDatasetResult): GetDatasetResult = GetDatasetResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            keys = javaType.keys().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.DatasetPropertyKeyResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            location = javaType.location(),
            name = javaType.name(),
            payload = javaType.payload().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timestamp = javaType.timestamp().map({ args0 -> args0 }).orElse(null),
            ttl = javaType.ttl().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
