@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A Pipeline resource belonging to an Instance resource.
 * @property description Detailed description of the Pipeline.
 * @property enabled Flag indicating whether the pipeline should be running or not.
 * @property extendedLocation Edge location of the resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property input Information about where to pull input data from.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property stages Map of stage ids to stage configurations for all pipeline processing and output stages.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetPipelineResult(
    public val description: String? = null,
    public val enabled: Boolean,
    public val extendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val input: PipelineInputResponse,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val stages: Map<String, PipelineStageResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsdataprocessor.outputs.GetPipelineResult): GetPipelineResult = GetPipelineResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            input = javaType.input().let({ args0 ->
                com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.PipelineInputResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            stages = javaType.stages().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.PipelineStageResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
