@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Stage configurations for all Pipeline processing and output stages.
 * @property description Description for stage.
 * @property next Next stage in the pipeline. Not required if output stage.
 * @property type ARM resource type.
 */
public data class PipelineStageResponse(
    public val description: String? = null,
    public val next: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsdataprocessor.outputs.PipelineStageResponse): PipelineStageResponse = PipelineStageResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            next = javaType.next().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
