@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.DataLakeDatabaseFormat
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.MqttProtocol
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.DataLakeTargetStorageArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.DataLakeTargetStorageArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.LocalBrokerConnectionSpecArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.LocalBrokerConnectionSpecArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ dataLakeConnector resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### DataLakeConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataLakeConnector = new AzureNative.IoTOperationsMQ.DataLakeConnector("dataLakeConnector", new()
 *     {
 *         DataLakeConnectorName = "87v4D",
 *         DatabaseFormat = AzureNative.IoTOperationsMQ.DataLakeDatabaseFormat.Delta,
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         Instances = 53467,
 *         LocalBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerAuthenticationMethodsArgs
 *             {
 *                 Kubernetes = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerKubernetesAuthenticationArgs
 *                 {
 *                     SecretPath = "soukzfkouir",
 *                     ServiceAccountTokenName = "suwetviuhmhorhvsidlznnufe",
 *                 },
 *             },
 *             Endpoint = "xc",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "rinkomfeznsfedbmllxlbmmhc",
 *             },
 *         },
 *         Location = "ewguwvlahlu",
 *         LogLevel = "ikicyoalavfmqlodnupfjayxjti",
 *         MqName = "Ox--3e65kYN0731DJ1Qg",
 *         NodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         Protocol = AzureNative.IoTOperationsMQ.MqttProtocol.V3,
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *         Target = new AzureNative.IoTOperationsMQ.Inputs.DataLakeTargetStorageArgs
 *         {
 *             DatalakeStorage = new AzureNative.IoTOperationsMQ.Inputs.DataLakeServiceStorageArgs
 *             {
 *                 Authentication = new AzureNative.IoTOperationsMQ.Inputs.DataLakeServiceStorageAuthenticationArgs
 *                 {
 *                     AccessTokenSecretName = "cfaoxjbfbwdldqjbfczvovgooyqkl",
 *                     SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                     {
 *                         Audience = "kjderojhpehosgfcrxxbh",
 *                         ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                     },
 *                 },
 *                 Endpoint = "bddy",
 *             },
 *             FabricOneLake = new AzureNative.IoTOperationsMQ.Inputs.DataLakeFabricStorageArgs
 *             {
 *                 Authentication = new AzureNative.IoTOperationsMQ.Inputs.DataLakeFabricStorageAuthenticationArgs
 *                 {
 *                     SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                     {
 *                         Audience = "kjderojhpehosgfcrxxbh",
 *                         ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                     },
 *                 },
 *                 Endpoint = "S.fabric.microsoft.com",
 *                 FabricPath = AzureNative.IoTOperationsMQ.FabricPathType.Files,
 *                 Guids = new AzureNative.IoTOperationsMQ.Inputs.FabricGuidsArgs
 *                 {
 *                     LakehouseGuid = "grsapopwjnuzbmnxbjnawaae",
 *                     WorkspaceGuid = "iwqfplayvdkdxumpdc",
 *                 },
 *                 Names = new AzureNative.IoTOperationsMQ.Inputs.FabricNamesArgs
 *                 {
 *                     LakehouseName = "iqgqtk",
 *                     WorkspaceName = "fxvlfhfcmlhcbgpopyqfikqsryct",
 *                 },
 *             },
 *             LocalStorage = new AzureNative.IoTOperationsMQ.Inputs.DataLakeLocalStorageArgs
 *             {
 *                 VolumeName = "nmzsioldiwteljpplmftk",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewDataLakeConnector(ctx, "dataLakeConnector", &iotoperationsmq.DataLakeConnectorArgs{
 * 			DataLakeConnectorName: pulumi.String("87v4D"),
 * 			DatabaseFormat:        pulumi.String(iotoperationsmq.DataLakeDatabaseFormatDelta),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			Image: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			Instances: pulumi.Int(53467),
 * 			LocalBrokerConnection: &iotoperationsmq.LocalBrokerConnectionSpecArgs{
 * 				Authentication: &iotoperationsmq.LocalBrokerAuthenticationMethodsArgs{
 * 					Kubernetes: &iotoperationsmq.LocalBrokerKubernetesAuthenticationArgs{
 * 						SecretPath:              pulumi.String("soukzfkouir"),
 * 						ServiceAccountTokenName: pulumi.String("suwetviuhmhorhvsidlznnufe"),
 * 					},
 * 				},
 * 				Endpoint: pulumi.String("xc"),
 * 				Tls: &iotoperationsmq.LocalBrokerConnectionTlsArgs{
 * 					TlsEnabled:                    pulumi.Bool(true),
 * 					TrustedCaCertificateConfigMap: pulumi.String("rinkomfeznsfedbmllxlbmmhc"),
 * 				},
 * 			},
 * 			Location: pulumi.String("ewguwvlahlu"),
 * 			LogLevel: pulumi.String("ikicyoalavfmqlodnupfjayxjti"),
 * 			MqName:   pulumi.String("Ox--3e65kYN0731DJ1Qg"),
 * 			NodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * 				Effect:   pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * 				Key:      pulumi.String("wbrstdwxgm"),
 * 				Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * 				Value:    pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * 			},
 * 			Protocol:          pulumi.String(iotoperationsmq.MqttProtocolV3),
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 			Target: &iotoperationsmq.DataLakeTargetStorageArgs{
 * 				DatalakeStorage: &iotoperationsmq.DataLakeServiceStorageArgs{
 * 					Authentication: &iotoperationsmq.DataLakeServiceStorageAuthenticationArgs{
 * 						AccessTokenSecretName: pulumi.String("cfaoxjbfbwdldqjbfczvovgooyqkl"),
 * 						SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * 							Audience:      pulumi.String("kjderojhpehosgfcrxxbh"),
 * 							ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * 						},
 * 					},
 * 					Endpoint: pulumi.String("bddy"),
 * 				},
 * 				FabricOneLake: &iotoperationsmq.DataLakeFabricStorageArgs{
 * 					Authentication: &iotoperationsmq.DataLakeFabricStorageAuthenticationArgs{
 * 						SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * 							Audience:      pulumi.String("kjderojhpehosgfcrxxbh"),
 * 							ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * 						},
 * 					},
 * 					Endpoint:   pulumi.String("S.fabric.microsoft.com"),
 * 					FabricPath: pulumi.String(iotoperationsmq.FabricPathTypeFiles),
 * 					Guids: &iotoperationsmq.FabricGuidsArgs{
 * 						LakehouseGuid: pulumi.String("grsapopwjnuzbmnxbjnawaae"),
 * 						WorkspaceGuid: pulumi.String("iwqfplayvdkdxumpdc"),
 * 					},
 * 					Names: &iotoperationsmq.FabricNamesArgs{
 * 						LakehouseName: pulumi.String("iqgqtk"),
 * 						WorkspaceName: pulumi.String("fxvlfhfcmlhcbgpopyqfikqsryct"),
 * 					},
 * 				},
 * 				LocalStorage: &iotoperationsmq.DataLakeLocalStorageArgs{
 * 					VolumeName: pulumi.String("nmzsioldiwteljpplmftk"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnector;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionSpecArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerAuthenticationMethodsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerKubernetesAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionTlsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeTargetStorageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeServiceStorageAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ManagedIdentityAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.FabricGuidsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.FabricNamesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeLocalStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataLakeConnector = new DataLakeConnector("dataLakeConnector", DataLakeConnectorArgs.builder()
 *             .dataLakeConnectorName("87v4D")
 *             .databaseFormat("delta")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .image(ContainerImageArgs.builder()
 *                 .pullPolicy("imfuzvqxgbdwliqnn")
 *                 .pullSecrets("klnqimxqsrdwhcqldjvdtsrs")
 *                 .repository("m")
 *                 .tag("jygfdiamhhm")
 *                 .build())
 *             .instances(53467)
 *             .localBrokerConnection(LocalBrokerConnectionSpecArgs.builder()
 *                 .authentication(LocalBrokerAuthenticationMethodsArgs.builder()
 *                     .kubernetes(LocalBrokerKubernetesAuthenticationArgs.builder()
 *                         .secretPath("soukzfkouir")
 *                         .serviceAccountTokenName("suwetviuhmhorhvsidlznnufe")
 *                         .build())
 *                     .build())
 *                 .endpoint("xc")
 *                 .tls(LocalBrokerConnectionTlsArgs.builder()
 *                     .tlsEnabled(true)
 *                     .trustedCaCertificateConfigMap("rinkomfeznsfedbmllxlbmmhc")
 *                     .build())
 *                 .build())
 *             .location("ewguwvlahlu")
 *             .logLevel("ikicyoalavfmqlodnupfjayxjti")
 *             .mqName("Ox--3e65kYN0731DJ1Qg")
 *             .nodeTolerations(NodeTolerationsArgs.builder()
 *                 .effect("eeswvciblqmmaeesjoflyvxqbz")
 *                 .key("wbrstdwxgm")
 *                 .operator("lbegegneekwnyodtzraarivtwhmzep")
 *                 .value("sfafsjdcezdmkwibxeluukxgl")
 *                 .build())
 *             .protocol("v3")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .target(DataLakeTargetStorageArgs.builder()
 *                 .datalakeStorage(DataLakeServiceStorageArgs.builder()
 *                     .authentication(DataLakeServiceStorageAuthenticationArgs.builder()
 *                         .accessTokenSecretName("cfaoxjbfbwdldqjbfczvovgooyqkl")
 *                         .systemAssignedManagedIdentity(ManagedIdentityAuthenticationArgs.builder()
 *                             .audience("kjderojhpehosgfcrxxbh")
 *                             .extensionName("cyckjqqzspleajbtkniwrfsqygjfhe")
 *                             .build())
 *                         .build())
 *                     .endpoint("bddy")
 *                     .build())
 *                 .fabricOneLake(DataLakeFabricStorageArgs.builder()
 *                     .authentication(DataLakeFabricStorageAuthenticationArgs.builder()
 *                         .systemAssignedManagedIdentity(ManagedIdentityAuthenticationArgs.builder()
 *                             .audience("kjderojhpehosgfcrxxbh")
 *                             .extensionName("cyckjqqzspleajbtkniwrfsqygjfhe")
 *                             .build())
 *                         .build())
 *                     .endpoint("S.fabric.microsoft.com")
 *                     .fabricPath("files")
 *                     .guids(FabricGuidsArgs.builder()
 *                         .lakehouseGuid("grsapopwjnuzbmnxbjnawaae")
 *                         .workspaceGuid("iwqfplayvdkdxumpdc")
 *                         .build())
 *                     .names(FabricNamesArgs.builder()
 *                         .lakehouseName("iqgqtk")
 *                         .workspaceName("fxvlfhfcmlhcbgpopyqfikqsryct")
 *                         .build())
 *                     .build())
 *                 .localStorage(DataLakeLocalStorageArgs.builder()
 *                     .volumeName("nmzsioldiwteljpplmftk")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:DataLakeConnector yduqhtfsalzehud /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/dataLakeConnector/{dataLakeConnectorName}
 * ```
 * @property dataLakeConnectorName Name of MQ dataLakeConnector resource
 * @property databaseFormat DataLake database format to use.
 * @property extendedLocation Extended Location
 * @property image The details of DataLakeConnector Docker Image.
 * @property instances The number of DataLakeConnector pods to spin up.
 * @property localBrokerConnection The details for connecting with Local Broker.
 * @property location The geo-location where the resource lives
 * @property logLevel The log level of the DataLake Connector instances.
 * @property mqName Name of MQ resource
 * @property nodeTolerations The Node Tolerations for the DataLake Connector pods.
 * @property protocol The protocol to use for connecting with Brokers.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property target The protocol to use for connecting with Brokers. NOTE - Enum only storage is supported at at time.
 */
public data class DataLakeConnectorArgs(
    public val dataLakeConnectorName: Output<String>? = null,
    public val databaseFormat: Output<Either<String, DataLakeDatabaseFormat>>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val image: Output<ContainerImageArgs>? = null,
    public val instances: Output<Int>? = null,
    public val localBrokerConnection: Output<LocalBrokerConnectionSpecArgs>? = null,
    public val location: Output<String>? = null,
    public val logLevel: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val nodeTolerations: Output<NodeTolerationsArgs>? = null,
    public val protocol: Output<Either<String, MqttProtocol>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val target: Output<DataLakeTargetStorageArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorArgs =
        com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorArgs.builder()
            .dataLakeConnectorName(dataLakeConnectorName?.applyValue({ args0 -> args0 }))
            .databaseFormat(
                databaseFormat?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instances(instances?.applyValue({ args0 -> args0 }))
            .localBrokerConnection(
                localBrokerConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .nodeTolerations(nodeTolerations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocol(
                protocol?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .target(target?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataLakeConnectorArgs].
 */
@PulumiTagMarker
public class DataLakeConnectorArgsBuilder internal constructor() {
    private var dataLakeConnectorName: Output<String>? = null

    private var databaseFormat: Output<Either<String, DataLakeDatabaseFormat>>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var image: Output<ContainerImageArgs>? = null

    private var instances: Output<Int>? = null

    private var localBrokerConnection: Output<LocalBrokerConnectionSpecArgs>? = null

    private var location: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var mqName: Output<String>? = null

    private var nodeTolerations: Output<NodeTolerationsArgs>? = null

    private var protocol: Output<Either<String, MqttProtocol>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var target: Output<DataLakeTargetStorageArgs>? = null

    /**
     * @param value Name of MQ dataLakeConnector resource
     */
    @JvmName("mqvcsayemuktjqut")
    public suspend fun dataLakeConnectorName(`value`: Output<String>) {
        this.dataLakeConnectorName = value
    }

    /**
     * @param value DataLake database format to use.
     */
    @JvmName("pecsamrbfriqnuep")
    public suspend fun databaseFormat(`value`: Output<Either<String, DataLakeDatabaseFormat>>) {
        this.databaseFormat = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("sbxvfjlfdgkgrjje")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The details of DataLakeConnector Docker Image.
     */
    @JvmName("ptlrtxracmssowul")
    public suspend fun image(`value`: Output<ContainerImageArgs>) {
        this.image = value
    }

    /**
     * @param value The number of DataLakeConnector pods to spin up.
     */
    @JvmName("vslhdchhldiipbeh")
    public suspend fun instances(`value`: Output<Int>) {
        this.instances = value
    }

    /**
     * @param value The details for connecting with Local Broker.
     */
    @JvmName("dvdxxriseoihrjwj")
    public suspend fun localBrokerConnection(`value`: Output<LocalBrokerConnectionSpecArgs>) {
        this.localBrokerConnection = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("mqddoilpsdmftgwx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The log level of the DataLake Connector instances.
     */
    @JvmName("eyrvinrggxgwwdir")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("ghxskggqsibwdiik")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The Node Tolerations for the DataLake Connector pods.
     */
    @JvmName("chwrfuyfclpmbijp")
    public suspend fun nodeTolerations(`value`: Output<NodeTolerationsArgs>) {
        this.nodeTolerations = value
    }

    /**
     * @param value The protocol to use for connecting with Brokers.
     */
    @JvmName("afrlmxsjvxvcffcu")
    public suspend fun protocol(`value`: Output<Either<String, MqttProtocol>>) {
        this.protocol = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("otyyufbekbxjadjd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vnalsghchwrfqnyu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The protocol to use for connecting with Brokers. NOTE - Enum only storage is supported at at time.
     */
    @JvmName("hetjjikelbdtrjbd")
    public suspend fun target(`value`: Output<DataLakeTargetStorageArgs>) {
        this.target = value
    }

    /**
     * @param value Name of MQ dataLakeConnector resource
     */
    @JvmName("tpxjryhdyfmhaiec")
    public suspend fun dataLakeConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakeConnectorName = mapped
    }

    /**
     * @param value DataLake database format to use.
     */
    @JvmName("ehhiynjlcerkylkh")
    public suspend fun databaseFormat(`value`: Either<String, DataLakeDatabaseFormat>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseFormat = mapped
    }

    /**
     * @param value DataLake database format to use.
     */
    @JvmName("bttcfusqajtyoufm")
    public fun databaseFormat(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DataLakeDatabaseFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseFormat = mapped
    }

    /**
     * @param value DataLake database format to use.
     */
    @JvmName("vmtoklmcjscbkrgv")
    public fun databaseFormat(`value`: DataLakeDatabaseFormat) {
        val toBeMapped = Either.ofRight<String, DataLakeDatabaseFormat>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseFormat = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("jmioikauvtxjddcg")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("bkinjniwjhrakwlt")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The details of DataLakeConnector Docker Image.
     */
    @JvmName("fcuiwyalkshycpxw")
    public suspend fun image(`value`: ContainerImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument The details of DataLakeConnector Docker Image.
     */
    @JvmName("iivkqqiekmjryrwu")
    public suspend fun image(argument: suspend ContainerImageArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value The number of DataLakeConnector pods to spin up.
     */
    @JvmName("dmxmfwpsebacubwo")
    public suspend fun instances(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The details for connecting with Local Broker.
     */
    @JvmName("gtijudsckeifxwpx")
    public suspend fun localBrokerConnection(`value`: LocalBrokerConnectionSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localBrokerConnection = mapped
    }

    /**
     * @param argument The details for connecting with Local Broker.
     */
    @JvmName("dfofkiuehuersera")
    public suspend fun localBrokerConnection(argument: suspend LocalBrokerConnectionSpecArgsBuilder.() -> Unit) {
        val toBeMapped = LocalBrokerConnectionSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localBrokerConnection = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("iylegyavtdgfpvet")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The log level of the DataLake Connector instances.
     */
    @JvmName("fwsmuyysctibakel")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("vynntwcribfhxdsi")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The Node Tolerations for the DataLake Connector pods.
     */
    @JvmName("htjyjfxoseudanpg")
    public suspend fun nodeTolerations(`value`: NodeTolerationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeTolerations = mapped
    }

    /**
     * @param argument The Node Tolerations for the DataLake Connector pods.
     */
    @JvmName("ugprneujsnkobsyj")
    public suspend fun nodeTolerations(argument: suspend NodeTolerationsArgsBuilder.() -> Unit) {
        val toBeMapped = NodeTolerationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodeTolerations = mapped
    }

    /**
     * @param value The protocol to use for connecting with Brokers.
     */
    @JvmName("udlbvkpwelvhinov")
    public suspend fun protocol(`value`: Either<String, MqttProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol to use for connecting with Brokers.
     */
    @JvmName("cddwdipmewqqrnkc")
    public fun protocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MqttProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The protocol to use for connecting with Brokers.
     */
    @JvmName("fuckfycgqgwahsye")
    public fun protocol(`value`: MqttProtocol) {
        val toBeMapped = Either.ofRight<String, MqttProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("btlatshjnhpnsoiy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wchnsrslgemxlhft")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gflcngidfoslawxn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The protocol to use for connecting with Brokers. NOTE - Enum only storage is supported at at time.
     */
    @JvmName("rwoguwknfofoxsrs")
    public suspend fun target(`value`: DataLakeTargetStorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument The protocol to use for connecting with Brokers. NOTE - Enum only storage is supported at at time.
     */
    @JvmName("ghywqtfxoohlcajl")
    public suspend fun target(argument: suspend DataLakeTargetStorageArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeTargetStorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    internal fun build(): DataLakeConnectorArgs = DataLakeConnectorArgs(
        dataLakeConnectorName = dataLakeConnectorName,
        databaseFormat = databaseFormat,
        extendedLocation = extendedLocation,
        image = image,
        instances = instances,
        localBrokerConnection = localBrokerConnection,
        location = location,
        logLevel = logLevel,
        mqName = mqName,
        nodeTolerations = nodeTolerations,
        protocol = protocol,
        resourceGroupName = resourceGroupName,
        tags = tags,
        target = target,
    )
}
