@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMapArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.DataLakeConnectorMapArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.DataLakeConnectorMapArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ dataLakeConnector/topicMap resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### DataLakeConnectorTopicMap_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataLakeConnectorTopicMap = new AzureNative.IoTOperationsMQ.DataLakeConnectorTopicMap("dataLakeConnectorTopicMap", new()
 *     {
 *         DataLakeConnectorName = "E9gU89-1QnIG7-IP8qOQLV-",
 *         DataLakeConnectorRef = "zirczjfua",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         Location = "wjmgeh",
 *         Mapping = new AzureNative.IoTOperationsMQ.Inputs.DataLakeConnectorMapArgs
 *         {
 *             AllowedLatencySecs = 25407,
 *             ClientId = "gyjduryceozwqyjdrxhrtwuw",
 *             MaxMessagesPerBatch = 1581641880,
 *             MessagePayloadType = "pwhpwzqlzlhdrozpqziipvjqrnipo",
 *             MqttSourceTopic = "mtac",
 *             Qos = 2,
 *             Table = new AzureNative.IoTOperationsMQ.Inputs.DeltaTableArgs
 *             {
 *                 Schema = new[]
 *                 {
 *                     new AzureNative.IoTOperationsMQ.Inputs.DeltaTableSchemaArgs
 *                     {
 *                         Format = AzureNative.IoTOperationsMQ.DeltaTableFormatEnum.Boolean,
 *                         Mapping = "lfnyjp",
 *                         Name = "hejqncdsueoerueffbaqix",
 *                         Optional = true,
 *                     },
 *                 },
 *                 TableName = "qyvzigmefvxwyjqksofyrstn",
 *                 TablePath = "cyrkvxsjhbhwjegmhzyixchkdnxe",
 *             },
 *         },
 *         MqName = "rc-8Z--2m-MU",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *         TopicMapName = "17-",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewDataLakeConnectorTopicMap(ctx, "dataLakeConnectorTopicMap", &iotoperationsmq.DataLakeConnectorTopicMapArgs{
 * 			DataLakeConnectorName: pulumi.String("E9gU89-1QnIG7-IP8qOQLV-"),
 * 			DataLakeConnectorRef:  pulumi.String("zirczjfua"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			Location: pulumi.String("wjmgeh"),
 * 			Mapping: &iotoperationsmq.DataLakeConnectorMapArgs{
 * 				AllowedLatencySecs:  pulumi.Int(25407),
 * 				ClientId:            pulumi.String("gyjduryceozwqyjdrxhrtwuw"),
 * 				MaxMessagesPerBatch: pulumi.Float64(1581641880),
 * 				MessagePayloadType:  pulumi.String("pwhpwzqlzlhdrozpqziipvjqrnipo"),
 * 				MqttSourceTopic:     pulumi.String("mtac"),
 * 				Qos:                 pulumi.Int(2),
 * 				Table: &iotoperationsmq.DeltaTableArgs{
 * 					Schema: iotoperationsmq.DeltaTableSchemaArray{
 * 						&iotoperationsmq.DeltaTableSchemaArgs{
 * 							Format:   pulumi.String(iotoperationsmq.DeltaTableFormatEnumBoolean),
 * 							Mapping:  pulumi.String("lfnyjp"),
 * 							Name:     pulumi.String("hejqncdsueoerueffbaqix"),
 * 							Optional: pulumi.Bool(true),
 * 						},
 * 					},
 * 					TableName: pulumi.String("qyvzigmefvxwyjqksofyrstn"),
 * 					TablePath: pulumi.String("cyrkvxsjhbhwjegmhzyixchkdnxe"),
 * 				},
 * 			},
 * 			MqName:            pulumi.String("rc-8Z--2m-MU"),
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 			TopicMapName:      pulumi.String("17-"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMap;
 * import com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMapArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeConnectorMapArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.DeltaTableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataLakeConnectorTopicMap = new DataLakeConnectorTopicMap("dataLakeConnectorTopicMap", DataLakeConnectorTopicMapArgs.builder()
 *             .dataLakeConnectorName("E9gU89-1QnIG7-IP8qOQLV-")
 *             .dataLakeConnectorRef("zirczjfua")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .location("wjmgeh")
 *             .mapping(DataLakeConnectorMapArgs.builder()
 *                 .allowedLatencySecs(25407)
 *                 .clientId("gyjduryceozwqyjdrxhrtwuw")
 *                 .maxMessagesPerBatch(1581641880)
 *                 .messagePayloadType("pwhpwzqlzlhdrozpqziipvjqrnipo")
 *                 .mqttSourceTopic("mtac")
 *                 .qos(2)
 *                 .table(DeltaTableArgs.builder()
 *                     .schema(DeltaTableSchemaArgs.builder()
 *                         .format("boolean")
 *                         .mapping("lfnyjp")
 *                         .name("hejqncdsueoerueffbaqix")
 *                         .optional(true)
 *                         .build())
 *                     .tableName("qyvzigmefvxwyjqksofyrstn")
 *                     .tablePath("cyrkvxsjhbhwjegmhzyixchkdnxe")
 *                     .build())
 *                 .build())
 *             .mqName("rc-8Z--2m-MU")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .topicMapName("17-")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:DataLakeConnectorTopicMap l /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/dataLakeConnector/{dataLakeConnectorName}/topicMap/{topicMapName}
 * ```
 * @property dataLakeConnectorName Name of MQ dataLakeConnector resource
 * @property dataLakeConnectorRef DataLake Connector CRD to use.
 * @property extendedLocation Extended Location
 * @property location The geo-location where the resource lives
 * @property mapping TopicMap for DataLake connector.
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property topicMapName Name of MQ dataLakeConnector/topicMap resource
 */
public data class DataLakeConnectorTopicMapArgs(
    public val dataLakeConnectorName: Output<String>? = null,
    public val dataLakeConnectorRef: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val location: Output<String>? = null,
    public val mapping: Output<DataLakeConnectorMapArgs>? = null,
    public val mqName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topicMapName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMapArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMapArgs =
        com.pulumi.azurenative.iotoperationsmq.DataLakeConnectorTopicMapArgs.builder()
            .dataLakeConnectorName(dataLakeConnectorName?.applyValue({ args0 -> args0 }))
            .dataLakeConnectorRef(dataLakeConnectorRef?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mapping(mapping?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topicMapName(topicMapName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataLakeConnectorTopicMapArgs].
 */
@PulumiTagMarker
public class DataLakeConnectorTopicMapArgsBuilder internal constructor() {
    private var dataLakeConnectorName: Output<String>? = null

    private var dataLakeConnectorRef: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var location: Output<String>? = null

    private var mapping: Output<DataLakeConnectorMapArgs>? = null

    private var mqName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topicMapName: Output<String>? = null

    /**
     * @param value Name of MQ dataLakeConnector resource
     */
    @JvmName("cehylbuqopkoikms")
    public suspend fun dataLakeConnectorName(`value`: Output<String>) {
        this.dataLakeConnectorName = value
    }

    /**
     * @param value DataLake Connector CRD to use.
     */
    @JvmName("rbtcmuoauqnpdpee")
    public suspend fun dataLakeConnectorRef(`value`: Output<String>) {
        this.dataLakeConnectorRef = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("kcmnbcjfauddtvoa")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("anldhbrjxapwyyqi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value TopicMap for DataLake connector.
     */
    @JvmName("pvyfkeuwuvgogjdr")
    public suspend fun mapping(`value`: Output<DataLakeConnectorMapArgs>) {
        this.mapping = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("mutmtojdprrnhjph")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fnywppfsopibskut")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xigcmidqjpkvkamg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of MQ dataLakeConnector/topicMap resource
     */
    @JvmName("puiwxmyoyxdjisbg")
    public suspend fun topicMapName(`value`: Output<String>) {
        this.topicMapName = value
    }

    /**
     * @param value Name of MQ dataLakeConnector resource
     */
    @JvmName("fbndxjtxorylwbrn")
    public suspend fun dataLakeConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakeConnectorName = mapped
    }

    /**
     * @param value DataLake Connector CRD to use.
     */
    @JvmName("xllcjblmaitobaoh")
    public suspend fun dataLakeConnectorRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLakeConnectorRef = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("miguqortdejpyrrq")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("pmatvjqyoudqutog")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tnngrtkfxdkhskui")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value TopicMap for DataLake connector.
     */
    @JvmName("jtekhdgtvwjmukrn")
    public suspend fun mapping(`value`: DataLakeConnectorMapArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mapping = mapped
    }

    /**
     * @param argument TopicMap for DataLake connector.
     */
    @JvmName("cxpxaejlrfmqyoxm")
    public suspend fun mapping(argument: suspend DataLakeConnectorMapArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeConnectorMapArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.mapping = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("cfchrvsuempdfova")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vrpbopugidyvrcjy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aqmqqsnubyxwiagu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("doifttkptpnibbwn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of MQ dataLakeConnector/topicMap resource
     */
    @JvmName("svmbvocnqbuidffn")
    public suspend fun topicMapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicMapName = mapped
    }

    internal fun build(): DataLakeConnectorTopicMapArgs = DataLakeConnectorTopicMapArgs(
        dataLakeConnectorName = dataLakeConnectorName,
        dataLakeConnectorRef = dataLakeConnectorRef,
        extendedLocation = extendedLocation,
        location = location,
        mapping = mapping,
        mqName = mqName,
        resourceGroupName = resourceGroupName,
        tags = tags,
        topicMapName = topicMapName,
    )
}
