@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.DiagnosticServiceArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ diagnostic services resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### DiagnosticService_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticService = new AzureNative.IoTOperationsMQ.DiagnosticService("diagnosticService", new()
 *     {
 *         DataExportFrequencySeconds = 26084,
 *         DiagnosticServiceName = "73-1El3-1",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         Location = "sbhavoiabxjpuq",
 *         LogFormat = "i",
 *         LogLevel = "aomqhmpa",
 *         MaxDataStorageSize = 3757017229,
 *         MetricsPort = 37109,
 *         MqName = "6RCAgs-XQ-Y2HsUF2",
 *         OpenTelemetryTracesCollectorAddr = "ggqmprmjlmmkfdpb",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         StaleDataTimeoutSeconds = 51616,
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewDiagnosticService(ctx, "diagnosticService", &iotoperationsmq.DiagnosticServiceArgs{
 * 			DataExportFrequencySeconds: pulumi.Int(26084),
 * 			DiagnosticServiceName:      pulumi.String("73-1El3-1"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			Image: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			Location:                         pulumi.String("sbhavoiabxjpuq"),
 * 			LogFormat:                        pulumi.String("i"),
 * 			LogLevel:                         pulumi.String("aomqhmpa"),
 * 			MaxDataStorageSize:               pulumi.Float64(3757017229),
 * 			MetricsPort:                      pulumi.Int(37109),
 * 			MqName:                           pulumi.String("6RCAgs-XQ-Y2HsUF2"),
 * 			OpenTelemetryTracesCollectorAddr: pulumi.String("ggqmprmjlmmkfdpb"),
 * 			ResourceGroupName:                pulumi.String("rgiotoperationsmq"),
 * 			StaleDataTimeoutSeconds:          pulumi.Int(51616),
 * 			Tags:                             nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.DiagnosticService;
 * import com.pulumi.azurenative.iotoperationsmq.DiagnosticServiceArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticService = new DiagnosticService("diagnosticService", DiagnosticServiceArgs.builder()
 *             .dataExportFrequencySeconds(26084)
 *             .diagnosticServiceName("73-1El3-1")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .image(ContainerImageArgs.builder()
 *                 .pullPolicy("imfuzvqxgbdwliqnn")
 *                 .pullSecrets("klnqimxqsrdwhcqldjvdtsrs")
 *                 .repository("m")
 *                 .tag("jygfdiamhhm")
 *                 .build())
 *             .location("sbhavoiabxjpuq")
 *             .logFormat("i")
 *             .logLevel("aomqhmpa")
 *             .maxDataStorageSize(3757017229)
 *             .metricsPort(37109)
 *             .mqName("6RCAgs-XQ-Y2HsUF2")
 *             .openTelemetryTracesCollectorAddr("ggqmprmjlmmkfdpb")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .staleDataTimeoutSeconds(51616)
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:DiagnosticService kdpnnlr /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/diagnosticService/{diagnosticServiceName}
 * ```
 * @property dataExportFrequencySeconds The frequency at which the data will be exported.
 * @property diagnosticServiceName Name of MQ diagnostic resource
 * @property extendedLocation Extended Location
 * @property image The details of Diagnostic Service Docker Image.
 * @property location The geo-location where the resource lives
 * @property logFormat The format for the logs generated.
 * @property logLevel The format for the logs generated.
 * @property maxDataStorageSize The maximum data stored in MiB.
 * @property metricsPort The port at which metrics is exposed.
 * @property mqName Name of MQ resource
 * @property openTelemetryTracesCollectorAddr The destination to collect traces. Diagnostic service will push traces to this endpoint
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property staleDataTimeoutSeconds Metric inactivity timeout.
 * @property tags Resource tags.
 */
public data class DiagnosticServiceArgs(
    public val dataExportFrequencySeconds: Output<Int>? = null,
    public val diagnosticServiceName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val image: Output<ContainerImageArgs>? = null,
    public val location: Output<String>? = null,
    public val logFormat: Output<String>? = null,
    public val logLevel: Output<String>? = null,
    public val maxDataStorageSize: Output<Double>? = null,
    public val metricsPort: Output<Int>? = null,
    public val mqName: Output<String>? = null,
    public val openTelemetryTracesCollectorAddr: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val staleDataTimeoutSeconds: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.DiagnosticServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.DiagnosticServiceArgs =
        com.pulumi.azurenative.iotoperationsmq.DiagnosticServiceArgs.builder()
            .dataExportFrequencySeconds(dataExportFrequencySeconds?.applyValue({ args0 -> args0 }))
            .diagnosticServiceName(diagnosticServiceName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .logFormat(logFormat?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .maxDataStorageSize(maxDataStorageSize?.applyValue({ args0 -> args0 }))
            .metricsPort(metricsPort?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .openTelemetryTracesCollectorAddr(openTelemetryTracesCollectorAddr?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .staleDataTimeoutSeconds(staleDataTimeoutSeconds?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DiagnosticServiceArgs].
 */
@PulumiTagMarker
public class DiagnosticServiceArgsBuilder internal constructor() {
    private var dataExportFrequencySeconds: Output<Int>? = null

    private var diagnosticServiceName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var image: Output<ContainerImageArgs>? = null

    private var location: Output<String>? = null

    private var logFormat: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var maxDataStorageSize: Output<Double>? = null

    private var metricsPort: Output<Int>? = null

    private var mqName: Output<String>? = null

    private var openTelemetryTracesCollectorAddr: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var staleDataTimeoutSeconds: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The frequency at which the data will be exported.
     */
    @JvmName("wqcqgagwcpwybjdq")
    public suspend fun dataExportFrequencySeconds(`value`: Output<Int>) {
        this.dataExportFrequencySeconds = value
    }

    /**
     * @param value Name of MQ diagnostic resource
     */
    @JvmName("kujrnvejomanhkkc")
    public suspend fun diagnosticServiceName(`value`: Output<String>) {
        this.diagnosticServiceName = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("ovbswmtbtrbdvsnx")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The details of Diagnostic Service Docker Image.
     */
    @JvmName("migfjyrawgowiluy")
    public suspend fun image(`value`: Output<ContainerImageArgs>) {
        this.image = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("svsfgspsypwxfirh")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The format for the logs generated.
     */
    @JvmName("txxpmgcrkcklnpes")
    public suspend fun logFormat(`value`: Output<String>) {
        this.logFormat = value
    }

    /**
     * @param value The format for the logs generated.
     */
    @JvmName("fvndeffehjoneuey")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value The maximum data stored in MiB.
     */
    @JvmName("gsnvxytywifldkbh")
    public suspend fun maxDataStorageSize(`value`: Output<Double>) {
        this.maxDataStorageSize = value
    }

    /**
     * @param value The port at which metrics is exposed.
     */
    @JvmName("cwuppigckguomvun")
    public suspend fun metricsPort(`value`: Output<Int>) {
        this.metricsPort = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("tyywdoqjttjxqiju")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The destination to collect traces. Diagnostic service will push traces to this endpoint
     */
    @JvmName("kprstgqhsdnauupi")
    public suspend fun openTelemetryTracesCollectorAddr(`value`: Output<String>) {
        this.openTelemetryTracesCollectorAddr = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("thlvvschhvpugmln")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Metric inactivity timeout.
     */
    @JvmName("tllorywdpvdslctd")
    public suspend fun staleDataTimeoutSeconds(`value`: Output<Int>) {
        this.staleDataTimeoutSeconds = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tkocohylvodepurj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The frequency at which the data will be exported.
     */
    @JvmName("rbniwagvuimdgmje")
    public suspend fun dataExportFrequencySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataExportFrequencySeconds = mapped
    }

    /**
     * @param value Name of MQ diagnostic resource
     */
    @JvmName("nabqnlssykyeklla")
    public suspend fun diagnosticServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagnosticServiceName = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("kcboqyrbqphbmeab")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("hjtewabiyaavajuc")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The details of Diagnostic Service Docker Image.
     */
    @JvmName("wkjocncyguitdxhw")
    public suspend fun image(`value`: ContainerImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument The details of Diagnostic Service Docker Image.
     */
    @JvmName("jyusqaijftuhjmpr")
    public suspend fun image(argument: suspend ContainerImageArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xhonxbnivfolysos")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The format for the logs generated.
     */
    @JvmName("xxrwshwuxxpmxnbq")
    public suspend fun logFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logFormat = mapped
    }

    /**
     * @param value The format for the logs generated.
     */
    @JvmName("iqjqrdvwvagtrhdp")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value The maximum data stored in MiB.
     */
    @JvmName("utbhnmxovaplkuit")
    public suspend fun maxDataStorageSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDataStorageSize = mapped
    }

    /**
     * @param value The port at which metrics is exposed.
     */
    @JvmName("mgfrrivbuwmdneek")
    public suspend fun metricsPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricsPort = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("hkbjpdvugoaxfudu")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The destination to collect traces. Diagnostic service will push traces to this endpoint
     */
    @JvmName("jcrhusygoaoghiaq")
    public suspend fun openTelemetryTracesCollectorAddr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openTelemetryTracesCollectorAddr = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qfcbiajdifypojoh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Metric inactivity timeout.
     */
    @JvmName("ovuwybyateawkhwq")
    public suspend fun staleDataTimeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staleDataTimeoutSeconds = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("krvpdalxemkwpckx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("inoqhhckdlbfnxlf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DiagnosticServiceArgs = DiagnosticServiceArgs(
        dataExportFrequencySeconds = dataExportFrequencySeconds,
        diagnosticServiceName = diagnosticServiceName,
        extendedLocation = extendedLocation,
        image = image,
        location = location,
        logFormat = logFormat,
        logLevel = logLevel,
        maxDataStorageSize = maxDataStorageSize,
        metricsPort = metricsPort,
        mqName = mqName,
        openTelemetryTracesCollectorAddr = openTelemetryTracesCollectorAddr,
        resourceGroupName = resourceGroupName,
        staleDataTimeoutSeconds = staleDataTimeoutSeconds,
        tags = tags,
    )
}
