@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getBrokerAuthenticationPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getBrokerAuthorizationPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getBrokerListenerPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getBrokerPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getDataLakeConnectorPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getDataLakeConnectorTopicMapPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getDiagnosticServicePlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getKafkaConnectorPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getKafkaConnectorTopicMapPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getMqPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getMqttBridgeConnectorPlain
import com.pulumi.azurenative.iotoperationsmq.IotoperationsmqFunctions.getMqttBridgeTopicMapPlain
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetBrokerAuthenticationPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetBrokerAuthenticationPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetBrokerAuthorizationPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetBrokerAuthorizationPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetBrokerListenerPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetBrokerListenerPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetBrokerPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetBrokerPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetDataLakeConnectorPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetDataLakeConnectorPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetDataLakeConnectorTopicMapPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetDataLakeConnectorTopicMapPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetDiagnosticServicePlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetDiagnosticServicePlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetKafkaConnectorPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetKafkaConnectorPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetKafkaConnectorTopicMapPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetKafkaConnectorTopicMapPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetMqPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetMqPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetMqttBridgeConnectorPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetMqttBridgeConnectorPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetMqttBridgeTopicMapPlainArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.GetMqttBridgeTopicMapPlainArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetBrokerAuthenticationResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetBrokerAuthorizationResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetBrokerListenerResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetBrokerResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetDataLakeConnectorResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetDataLakeConnectorTopicMapResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetDiagnosticServiceResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetKafkaConnectorResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetKafkaConnectorTopicMapResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetMqResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetMqttBridgeConnectorResult
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetMqttBridgeTopicMapResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetBrokerAuthenticationResult.Companion.toKotlin as getBrokerAuthenticationResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetBrokerAuthorizationResult.Companion.toKotlin as getBrokerAuthorizationResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetBrokerListenerResult.Companion.toKotlin as getBrokerListenerResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetBrokerResult.Companion.toKotlin as getBrokerResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetDataLakeConnectorResult.Companion.toKotlin as getDataLakeConnectorResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetDataLakeConnectorTopicMapResult.Companion.toKotlin as getDataLakeConnectorTopicMapResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetDiagnosticServiceResult.Companion.toKotlin as getDiagnosticServiceResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetKafkaConnectorResult.Companion.toKotlin as getKafkaConnectorResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetKafkaConnectorTopicMapResult.Companion.toKotlin as getKafkaConnectorTopicMapResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetMqResult.Companion.toKotlin as getMqResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetMqttBridgeConnectorResult.Companion.toKotlin as getMqttBridgeConnectorResultToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.GetMqttBridgeTopicMapResult.Companion.toKotlin as getMqttBridgeTopicMapResultToKotlin

public object IotoperationsmqFunctions {
    /**
     * Get a BrokerResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ broker resource
     */
    public suspend fun getBroker(argument: GetBrokerPlainArgs): GetBrokerResult =
        getBrokerResultToKotlin(getBrokerPlain(argument.toJava()).await())

    /**
     * @see [getBroker].
     * @param brokerName Name of MQ broker resource
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MQ broker resource
     */
    public suspend fun getBroker(
        brokerName: String,
        mqName: String,
        resourceGroupName: String,
    ): GetBrokerResult {
        val argument = GetBrokerPlainArgs(
            brokerName = brokerName,
            mqName = mqName,
            resourceGroupName = resourceGroupName,
        )
        return getBrokerResultToKotlin(getBrokerPlain(argument.toJava()).await())
    }

    /**
     * @see [getBroker].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetBrokerPlainArgs].
     * @return MQ broker resource
     */
    public suspend fun getBroker(argument: suspend GetBrokerPlainArgsBuilder.() -> Unit): GetBrokerResult {
        val builder = GetBrokerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBrokerResultToKotlin(getBrokerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a BrokerAuthenticationResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ broker/authentication resource
     */
    public suspend fun getBrokerAuthentication(argument: GetBrokerAuthenticationPlainArgs): GetBrokerAuthenticationResult =
        getBrokerAuthenticationResultToKotlin(getBrokerAuthenticationPlain(argument.toJava()).await())

    /**
     * @see [getBrokerAuthentication].
     * @param authenticationName Name of MQ broker/authentication resource
     * @param brokerName Name of MQ broker resource
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MQ broker/authentication resource
     */
    public suspend fun getBrokerAuthentication(
        authenticationName: String,
        brokerName: String,
        mqName: String,
        resourceGroupName: String,
    ): GetBrokerAuthenticationResult {
        val argument = GetBrokerAuthenticationPlainArgs(
            authenticationName = authenticationName,
            brokerName = brokerName,
            mqName = mqName,
            resourceGroupName = resourceGroupName,
        )
        return getBrokerAuthenticationResultToKotlin(getBrokerAuthenticationPlain(argument.toJava()).await())
    }

    /**
     * @see [getBrokerAuthentication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetBrokerAuthenticationPlainArgs].
     * @return MQ broker/authentication resource
     */
    public suspend fun getBrokerAuthentication(argument: suspend GetBrokerAuthenticationPlainArgsBuilder.() -> Unit): GetBrokerAuthenticationResult {
        val builder = GetBrokerAuthenticationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBrokerAuthenticationResultToKotlin(getBrokerAuthenticationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a BrokerAuthorizationResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ broker/authorization resource
     */
    public suspend fun getBrokerAuthorization(argument: GetBrokerAuthorizationPlainArgs): GetBrokerAuthorizationResult =
        getBrokerAuthorizationResultToKotlin(getBrokerAuthorizationPlain(argument.toJava()).await())

    /**
     * @see [getBrokerAuthorization].
     * @param authorizationName Name of MQ broker/authorization resource
     * @param brokerName Name of MQ broker resource
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MQ broker/authorization resource
     */
    public suspend fun getBrokerAuthorization(
        authorizationName: String,
        brokerName: String,
        mqName: String,
        resourceGroupName: String,
    ): GetBrokerAuthorizationResult {
        val argument = GetBrokerAuthorizationPlainArgs(
            authorizationName = authorizationName,
            brokerName = brokerName,
            mqName = mqName,
            resourceGroupName = resourceGroupName,
        )
        return getBrokerAuthorizationResultToKotlin(getBrokerAuthorizationPlain(argument.toJava()).await())
    }

    /**
     * @see [getBrokerAuthorization].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetBrokerAuthorizationPlainArgs].
     * @return MQ broker/authorization resource
     */
    public suspend fun getBrokerAuthorization(argument: suspend GetBrokerAuthorizationPlainArgsBuilder.() -> Unit): GetBrokerAuthorizationResult {
        val builder = GetBrokerAuthorizationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBrokerAuthorizationResultToKotlin(getBrokerAuthorizationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a BrokerListenerResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ broker/listener resource
     */
    public suspend fun getBrokerListener(argument: GetBrokerListenerPlainArgs): GetBrokerListenerResult =
        getBrokerListenerResultToKotlin(getBrokerListenerPlain(argument.toJava()).await())

    /**
     * @see [getBrokerListener].
     * @param brokerName Name of MQ broker resource
     * @param listenerName Name of MQ broker/listener resource
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MQ broker/listener resource
     */
    public suspend fun getBrokerListener(
        brokerName: String,
        listenerName: String,
        mqName: String,
        resourceGroupName: String,
    ): GetBrokerListenerResult {
        val argument = GetBrokerListenerPlainArgs(
            brokerName = brokerName,
            listenerName = listenerName,
            mqName = mqName,
            resourceGroupName = resourceGroupName,
        )
        return getBrokerListenerResultToKotlin(getBrokerListenerPlain(argument.toJava()).await())
    }

    /**
     * @see [getBrokerListener].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetBrokerListenerPlainArgs].
     * @return MQ broker/listener resource
     */
    public suspend fun getBrokerListener(argument: suspend GetBrokerListenerPlainArgsBuilder.() -> Unit): GetBrokerListenerResult {
        val builder = GetBrokerListenerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBrokerListenerResultToKotlin(getBrokerListenerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataLakeConnectorResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ dataLakeConnector resource
     */
    public suspend fun getDataLakeConnector(argument: GetDataLakeConnectorPlainArgs): GetDataLakeConnectorResult =
        getDataLakeConnectorResultToKotlin(getDataLakeConnectorPlain(argument.toJava()).await())

    /**
     * @see [getDataLakeConnector].
     * @param dataLakeConnectorName Name of MQ dataLakeConnector resource
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MQ dataLakeConnector resource
     */
    public suspend fun getDataLakeConnector(
        dataLakeConnectorName: String,
        mqName: String,
        resourceGroupName: String,
    ): GetDataLakeConnectorResult {
        val argument = GetDataLakeConnectorPlainArgs(
            dataLakeConnectorName = dataLakeConnectorName,
            mqName = mqName,
            resourceGroupName = resourceGroupName,
        )
        return getDataLakeConnectorResultToKotlin(getDataLakeConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataLakeConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetDataLakeConnectorPlainArgs].
     * @return MQ dataLakeConnector resource
     */
    public suspend fun getDataLakeConnector(argument: suspend GetDataLakeConnectorPlainArgsBuilder.() -> Unit): GetDataLakeConnectorResult {
        val builder = GetDataLakeConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataLakeConnectorResultToKotlin(getDataLakeConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DataLakeTopicMapResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ dataLakeConnector/topicMap resource
     */
    public suspend fun getDataLakeConnectorTopicMap(argument: GetDataLakeConnectorTopicMapPlainArgs): GetDataLakeConnectorTopicMapResult =
        getDataLakeConnectorTopicMapResultToKotlin(getDataLakeConnectorTopicMapPlain(argument.toJava()).await())

    /**
     * @see [getDataLakeConnectorTopicMap].
     * @param dataLakeConnectorName Name of MQ dataLakeConnector resource
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param topicMapName Name of MQ dataLakeConnector/topicMap resource
     * @return MQ dataLakeConnector/topicMap resource
     */
    public suspend fun getDataLakeConnectorTopicMap(
        dataLakeConnectorName: String,
        mqName: String,
        resourceGroupName: String,
        topicMapName: String,
    ): GetDataLakeConnectorTopicMapResult {
        val argument = GetDataLakeConnectorTopicMapPlainArgs(
            dataLakeConnectorName = dataLakeConnectorName,
            mqName = mqName,
            resourceGroupName = resourceGroupName,
            topicMapName = topicMapName,
        )
        return getDataLakeConnectorTopicMapResultToKotlin(getDataLakeConnectorTopicMapPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataLakeConnectorTopicMap].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetDataLakeConnectorTopicMapPlainArgs].
     * @return MQ dataLakeConnector/topicMap resource
     */
    public suspend fun getDataLakeConnectorTopicMap(argument: suspend GetDataLakeConnectorTopicMapPlainArgsBuilder.() -> Unit): GetDataLakeConnectorTopicMapResult {
        val builder = GetDataLakeConnectorTopicMapPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataLakeConnectorTopicMapResultToKotlin(getDataLakeConnectorTopicMapPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a DiagnosticServiceResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ diagnostic services resource
     */
    public suspend fun getDiagnosticService(argument: GetDiagnosticServicePlainArgs): GetDiagnosticServiceResult =
        getDiagnosticServiceResultToKotlin(getDiagnosticServicePlain(argument.toJava()).await())

    /**
     * @see [getDiagnosticService].
     * @param diagnosticServiceName Name of MQ diagnostic resource
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MQ diagnostic services resource
     */
    public suspend fun getDiagnosticService(
        diagnosticServiceName: String,
        mqName: String,
        resourceGroupName: String,
    ): GetDiagnosticServiceResult {
        val argument = GetDiagnosticServicePlainArgs(
            diagnosticServiceName = diagnosticServiceName,
            mqName = mqName,
            resourceGroupName = resourceGroupName,
        )
        return getDiagnosticServiceResultToKotlin(getDiagnosticServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getDiagnosticService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetDiagnosticServicePlainArgs].
     * @return MQ diagnostic services resource
     */
    public suspend fun getDiagnosticService(argument: suspend GetDiagnosticServicePlainArgsBuilder.() -> Unit): GetDiagnosticServiceResult {
        val builder = GetDiagnosticServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDiagnosticServiceResultToKotlin(getDiagnosticServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Get a KafkaConnectorResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ kafkaConnector resource
     */
    public suspend fun getKafkaConnector(argument: GetKafkaConnectorPlainArgs): GetKafkaConnectorResult =
        getKafkaConnectorResultToKotlin(getKafkaConnectorPlain(argument.toJava()).await())

    /**
     * @see [getKafkaConnector].
     * @param kafkaConnectorName Name of MQ kafkaConnector resource
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MQ kafkaConnector resource
     */
    public suspend fun getKafkaConnector(
        kafkaConnectorName: String,
        mqName: String,
        resourceGroupName: String,
    ): GetKafkaConnectorResult {
        val argument = GetKafkaConnectorPlainArgs(
            kafkaConnectorName = kafkaConnectorName,
            mqName = mqName,
            resourceGroupName = resourceGroupName,
        )
        return getKafkaConnectorResultToKotlin(getKafkaConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getKafkaConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetKafkaConnectorPlainArgs].
     * @return MQ kafkaConnector resource
     */
    public suspend fun getKafkaConnector(argument: suspend GetKafkaConnectorPlainArgsBuilder.() -> Unit): GetKafkaConnectorResult {
        val builder = GetKafkaConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKafkaConnectorResultToKotlin(getKafkaConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a KafkaTopicMapResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ kafkaConnector/topicMap resource
     */
    public suspend fun getKafkaConnectorTopicMap(argument: GetKafkaConnectorTopicMapPlainArgs): GetKafkaConnectorTopicMapResult =
        getKafkaConnectorTopicMapResultToKotlin(getKafkaConnectorTopicMapPlain(argument.toJava()).await())

    /**
     * @see [getKafkaConnectorTopicMap].
     * @param kafkaConnectorName Name of MQ kafkaConnector resource
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param topicMapName Name of MQ kafka/topicMap resource
     * @return MQ kafkaConnector/topicMap resource
     */
    public suspend fun getKafkaConnectorTopicMap(
        kafkaConnectorName: String,
        mqName: String,
        resourceGroupName: String,
        topicMapName: String,
    ): GetKafkaConnectorTopicMapResult {
        val argument = GetKafkaConnectorTopicMapPlainArgs(
            kafkaConnectorName = kafkaConnectorName,
            mqName = mqName,
            resourceGroupName = resourceGroupName,
            topicMapName = topicMapName,
        )
        return getKafkaConnectorTopicMapResultToKotlin(getKafkaConnectorTopicMapPlain(argument.toJava()).await())
    }

    /**
     * @see [getKafkaConnectorTopicMap].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetKafkaConnectorTopicMapPlainArgs].
     * @return MQ kafkaConnector/topicMap resource
     */
    public suspend fun getKafkaConnectorTopicMap(argument: suspend GetKafkaConnectorTopicMapPlainArgsBuilder.() -> Unit): GetKafkaConnectorTopicMapResult {
        val builder = GetKafkaConnectorTopicMapPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKafkaConnectorTopicMapResultToKotlin(getKafkaConnectorTopicMapPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a MqResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ resource
     */
    public suspend fun getMq(argument: GetMqPlainArgs): GetMqResult =
        getMqResultToKotlin(getMqPlain(argument.toJava()).await())

    /**
     * @see [getMq].
     * @param mqName Name of MQ resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MQ resource
     */
    public suspend fun getMq(mqName: String, resourceGroupName: String): GetMqResult {
        val argument = GetMqPlainArgs(
            mqName = mqName,
            resourceGroupName = resourceGroupName,
        )
        return getMqResultToKotlin(getMqPlain(argument.toJava()).await())
    }

    /**
     * @see [getMq].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetMqPlainArgs].
     * @return MQ resource
     */
    public suspend fun getMq(argument: suspend GetMqPlainArgsBuilder.() -> Unit): GetMqResult {
        val builder = GetMqPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMqResultToKotlin(getMqPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a MqttBridgeConnectorResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ mqttBridgeConnector resource
     */
    public suspend fun getMqttBridgeConnector(argument: GetMqttBridgeConnectorPlainArgs): GetMqttBridgeConnectorResult =
        getMqttBridgeConnectorResultToKotlin(getMqttBridgeConnectorPlain(argument.toJava()).await())

    /**
     * @see [getMqttBridgeConnector].
     * @param mqName Name of MQ resource
     * @param mqttBridgeConnectorName Name of MQ mqttBridgeConnector resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return MQ mqttBridgeConnector resource
     */
    public suspend fun getMqttBridgeConnector(
        mqName: String,
        mqttBridgeConnectorName: String,
        resourceGroupName: String,
    ): GetMqttBridgeConnectorResult {
        val argument = GetMqttBridgeConnectorPlainArgs(
            mqName = mqName,
            mqttBridgeConnectorName = mqttBridgeConnectorName,
            resourceGroupName = resourceGroupName,
        )
        return getMqttBridgeConnectorResultToKotlin(getMqttBridgeConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getMqttBridgeConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetMqttBridgeConnectorPlainArgs].
     * @return MQ mqttBridgeConnector resource
     */
    public suspend fun getMqttBridgeConnector(argument: suspend GetMqttBridgeConnectorPlainArgsBuilder.() -> Unit): GetMqttBridgeConnectorResult {
        val builder = GetMqttBridgeConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMqttBridgeConnectorResultToKotlin(getMqttBridgeConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a MqttBridgeTopicMapResource
     * Azure REST API version: 2023-10-04-preview.
     * @param argument null
     * @return MQ mqttBridgeTopicMap resource
     */
    public suspend fun getMqttBridgeTopicMap(argument: GetMqttBridgeTopicMapPlainArgs): GetMqttBridgeTopicMapResult =
        getMqttBridgeTopicMapResultToKotlin(getMqttBridgeTopicMapPlain(argument.toJava()).await())

    /**
     * @see [getMqttBridgeTopicMap].
     * @param mqName Name of MQ resource
     * @param mqttBridgeConnectorName Name of MQ mqttBridgeConnector resource
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param topicMapName Name of MQ mqttBridgeTopicMap resource
     * @return MQ mqttBridgeTopicMap resource
     */
    public suspend fun getMqttBridgeTopicMap(
        mqName: String,
        mqttBridgeConnectorName: String,
        resourceGroupName: String,
        topicMapName: String,
    ): GetMqttBridgeTopicMapResult {
        val argument = GetMqttBridgeTopicMapPlainArgs(
            mqName = mqName,
            mqttBridgeConnectorName = mqttBridgeConnectorName,
            resourceGroupName = resourceGroupName,
            topicMapName = topicMapName,
        )
        return getMqttBridgeTopicMapResultToKotlin(getMqttBridgeTopicMapPlain(argument.toJava()).await())
    }

    /**
     * @see [getMqttBridgeTopicMap].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;iotoperationsmq&#46;kotlin&#46;inputs&#46;GetMqttBridgeTopicMapPlainArgs].
     * @return MQ mqttBridgeTopicMap resource
     */
    public suspend fun getMqttBridgeTopicMap(argument: suspend GetMqttBridgeTopicMapPlainArgsBuilder.() -> Unit): GetMqttBridgeTopicMapResult {
        val builder = GetMqttBridgeTopicMapPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMqttBridgeTopicMapResultToKotlin(getMqttBridgeTopicMapPlain(builtArgument.toJava()).await())
    }
}
