@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ContainerImageArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.KafkaRemoteBrokerConnectionSpecArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.KafkaRemoteBrokerConnectionSpecArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.LocalBrokerConnectionSpecArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.LocalBrokerConnectionSpecArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.NodeTolerationsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ kafkaConnector resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### KafkaConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kafkaConnector = new AzureNative.IoTOperationsMQ.KafkaConnector("kafkaConnector", new()
 *     {
 *         ClientIdPrefix = "yybbbeowkw",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         Instances = 55252,
 *         KafkaConnection = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerAuthenticationPropertiesArgs
 *             {
 *                 AuthType = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerAuthenticationTypesArgs
 *                 {
 *                     Sasl = new AzureNative.IoTOperationsMQ.Inputs.SaslRemoteBrokerBasicAuthenticationArgs
 *                     {
 *                         SaslType = AzureNative.IoTOperationsMQ.KafkaSaslType.Plain,
 *                         Token = new AzureNative.IoTOperationsMQ.Inputs.SaslRemoteBrokerBasicAuthenticationTokenArgs
 *                         {
 *                             KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KafkaTokenKeyVaultPropertiesArgs
 *                             {
 *                                 Username = "fb",
 *                                 Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                                 {
 *                                     Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                     {
 *                                         ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                     },
 *                                     DirectoryId = "eyjniptiykzcgbzok",
 *                                     Name = "lxmwfan",
 *                                 },
 *                                 VaultSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                                 {
 *                                     Name = "bmectskddmpjxnsogwooexj",
 *                                     Version = "unjfbf",
 *                                 },
 *                             },
 *                             SecretName = "hxmqokubwldgjdtjv",
 *                         },
 *                     },
 *                     SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                     {
 *                         Audience = "kjderojhpehosgfcrxxbh",
 *                         ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                     },
 *                     X509 = new AzureNative.IoTOperationsMQ.Inputs.KafkaX509AuthenticationArgs
 *                     {
 *                         KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCertificatePropertiesArgs
 *                         {
 *                             Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                             {
 *                                 Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                 {
 *                                     ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                 },
 *                                 DirectoryId = "eyjniptiykzcgbzok",
 *                                 Name = "lxmwfan",
 *                             },
 *                             VaultCaChainSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                             {
 *                                 Name = "bmectskddmpjxnsogwooexj",
 *                                 Version = "unjfbf",
 *                             },
 *                             VaultCert = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                             {
 *                                 Name = "bmectskddmpjxnsogwooexj",
 *                                 Version = "unjfbf",
 *                             },
 *                         },
 *                         SecretName = "jlrjvqyoygynlpsekfbvyrpu",
 *                     },
 *                 },
 *                 Enabled = true,
 *             },
 *             Endpoint = "odxpssuhjkbonjmbhbebfjcah",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.KafkaRemoteBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "kndjozglnxsgnzxq",
 *             },
 *         },
 *         KafkaConnectorName = "V5--OL8-R",
 *         LocalBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerAuthenticationMethodsArgs
 *             {
 *                 Kubernetes = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerKubernetesAuthenticationArgs
 *                 {
 *                     SecretPath = "soukzfkouir",
 *                     ServiceAccountTokenName = "suwetviuhmhorhvsidlznnufe",
 *                 },
 *             },
 *             Endpoint = "xc",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "rinkomfeznsfedbmllxlbmmhc",
 *             },
 *         },
 *         Location = "mpbupgmqssnb",
 *         LogLevel = "g",
 *         MqName = "s47Lj-S2S-Q-XY",
 *         NodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewKafkaConnector(ctx, "kafkaConnector", &iotoperationsmq.KafkaConnectorArgs{
 * 			ClientIdPrefix: pulumi.String("yybbbeowkw"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			Image: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			Instances: pulumi.Int(55252),
 * 			KafkaConnection: &iotoperationsmq.KafkaRemoteBrokerConnectionSpecArgs{
 * 				Authentication: &iotoperationsmq.KafkaRemoteBrokerAuthenticationPropertiesArgs{
 * 					AuthType: &iotoperationsmq.KafkaRemoteBrokerAuthenticationTypesArgs{
 * 						Sasl: &iotoperationsmq.SaslRemoteBrokerBasicAuthenticationArgs{
 * 							SaslType: pulumi.String(iotoperationsmq.KafkaSaslTypePlain),
 * 							Token: &iotoperationsmq.SaslRemoteBrokerBasicAuthenticationTokenArgs{
 * 								KeyVault: &iotoperationsmq.KafkaTokenKeyVaultPropertiesArgs{
 * 									Username: pulumi.String("fb"),
 * 									Vault: &iotoperationsmq.KeyVaultConnectionPropertiesArgs{
 * 										Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * 											ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 										},
 * 										DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 										Name:        pulumi.String("lxmwfan"),
 * 									},
 * 									VaultSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * 										Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 										Version: pulumi.String("unjfbf"),
 * 									},
 * 								},
 * 								SecretName: pulumi.String("hxmqokubwldgjdtjv"),
 * 							},
 * 						},
 * 						SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * 							Audience:      pulumi.String("kjderojhpehosgfcrxxbh"),
 * 							ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * 						},
 * 						X509: &iotoperationsmq.KafkaX509AuthenticationArgs{
 * 							KeyVault: &iotoperationsmq.KeyVaultCertificatePropertiesArgs{
 * 								Vault: &iotoperationsmq.KeyVaultConnectionPropertiesArgs{
 * 									Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * 										ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 									},
 * 									DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 									Name:        pulumi.String("lxmwfan"),
 * 								},
 * 								VaultCaChainSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * 									Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 									Version: pulumi.String("unjfbf"),
 * 								},
 * 								VaultCert: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * 									Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 									Version: pulumi.String("unjfbf"),
 * 								},
 * 							},
 * 							SecretName: pulumi.String("jlrjvqyoygynlpsekfbvyrpu"),
 * 						},
 * 					},
 * 					Enabled: pulumi.Bool(true),
 * 				},
 * 				Endpoint: pulumi.String("odxpssuhjkbonjmbhbebfjcah"),
 * 				Tls: &iotoperationsmq.KafkaRemoteBrokerConnectionTlsArgs{
 * 					TlsEnabled:                    pulumi.Bool(true),
 * 					TrustedCaCertificateConfigMap: pulumi.String("kndjozglnxsgnzxq"),
 * 				},
 * 			},
 * 			KafkaConnectorName: pulumi.String("V5--OL8-R"),
 * 			LocalBrokerConnection: &iotoperationsmq.LocalBrokerConnectionSpecArgs{
 * 				Authentication: &iotoperationsmq.LocalBrokerAuthenticationMethodsArgs{
 * 					Kubernetes: &iotoperationsmq.LocalBrokerKubernetesAuthenticationArgs{
 * 						SecretPath:              pulumi.String("soukzfkouir"),
 * 						ServiceAccountTokenName: pulumi.String("suwetviuhmhorhvsidlznnufe"),
 * 					},
 * 				},
 * 				Endpoint: pulumi.String("xc"),
 * 				Tls: &iotoperationsmq.LocalBrokerConnectionTlsArgs{
 * 					TlsEnabled:                    pulumi.Bool(true),
 * 					TrustedCaCertificateConfigMap: pulumi.String("rinkomfeznsfedbmllxlbmmhc"),
 * 				},
 * 			},
 * 			Location: pulumi.String("mpbupgmqssnb"),
 * 			LogLevel: pulumi.String("g"),
 * 			MqName:   pulumi.String("s47Lj-S2S-Q-XY"),
 * 			NodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * 				Effect:   pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * 				Key:      pulumi.String("wbrstdwxgm"),
 * 				Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * 				Value:    pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnector;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ContainerImageArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionSpecArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerAuthenticationTypesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.SaslRemoteBrokerBasicAuthenticationTokenArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTokenKeyVaultPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultConnectionPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCredentialsPropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultSecretObjectArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ManagedIdentityAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaX509AuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KeyVaultCertificatePropertiesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionTlsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionSpecArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerAuthenticationMethodsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerKubernetesAuthenticationArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionTlsArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kafkaConnector = new KafkaConnector("kafkaConnector", KafkaConnectorArgs.builder()
 *             .clientIdPrefix("yybbbeowkw")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .image(ContainerImageArgs.builder()
 *                 .pullPolicy("imfuzvqxgbdwliqnn")
 *                 .pullSecrets("klnqimxqsrdwhcqldjvdtsrs")
 *                 .repository("m")
 *                 .tag("jygfdiamhhm")
 *                 .build())
 *             .instances(55252)
 *             .kafkaConnection(KafkaRemoteBrokerConnectionSpecArgs.builder()
 *                 .authentication(KafkaRemoteBrokerAuthenticationPropertiesArgs.builder()
 *                     .authType(KafkaRemoteBrokerAuthenticationTypesArgs.builder()
 *                         .sasl(SaslRemoteBrokerBasicAuthenticationArgs.builder()
 *                             .saslType("plain")
 *                             .token(SaslRemoteBrokerBasicAuthenticationTokenArgs.builder()
 *                                 .keyVault(KafkaTokenKeyVaultPropertiesArgs.builder()
 *                                     .username("fb")
 *                                     .vault(KeyVaultConnectionPropertiesArgs.builder()
 *                                         .credentials(KeyVaultCredentialsPropertiesArgs.builder()
 *                                             .servicePrincipalLocalSecretName("wuimjwpbhoglbsxxa")
 *                                             .build())
 *                                         .directoryId("eyjniptiykzcgbzok")
 *                                         .name("lxmwfan")
 *                                         .build())
 *                                     .vaultSecret(KeyVaultSecretObjectArgs.builder()
 *                                         .name("bmectskddmpjxnsogwooexj")
 *                                         .version("unjfbf")
 *                                         .build())
 *                                     .build())
 *                                 .secretName("hxmqokubwldgjdtjv")
 *                                 .build())
 *                             .build())
 *                         .systemAssignedManagedIdentity(ManagedIdentityAuthenticationArgs.builder()
 *                             .audience("kjderojhpehosgfcrxxbh")
 *                             .extensionName("cyckjqqzspleajbtkniwrfsqygjfhe")
 *                             .build())
 *                         .x509(KafkaX509AuthenticationArgs.builder()
 *                             .keyVault(KeyVaultCertificatePropertiesArgs.builder()
 *                                 .vault(KeyVaultConnectionPropertiesArgs.builder()
 *                                     .credentials(KeyVaultCredentialsPropertiesArgs.builder()
 *                                         .servicePrincipalLocalSecretName("wuimjwpbhoglbsxxa")
 *                                         .build())
 *                                     .directoryId("eyjniptiykzcgbzok")
 *                                     .name("lxmwfan")
 *                                     .build())
 *                                 .vaultCaChainSecret(KeyVaultSecretObjectArgs.builder()
 *                                     .name("bmectskddmpjxnsogwooexj")
 *                                     .version("unjfbf")
 *                                     .build())
 *                                 .vaultCert(KeyVaultSecretObjectArgs.builder()
 *                                     .name("bmectskddmpjxnsogwooexj")
 *                                     .version("unjfbf")
 *                                     .build())
 *                                 .build())
 *                             .secretName("jlrjvqyoygynlpsekfbvyrpu")
 *                             .build())
 *                         .build())
 *                     .enabled(true)
 *                     .build())
 *                 .endpoint("odxpssuhjkbonjmbhbebfjcah")
 *                 .tls(KafkaRemoteBrokerConnectionTlsArgs.builder()
 *                     .tlsEnabled(true)
 *                     .trustedCaCertificateConfigMap("kndjozglnxsgnzxq")
 *                     .build())
 *                 .build())
 *             .kafkaConnectorName("V5--OL8-R")
 *             .localBrokerConnection(LocalBrokerConnectionSpecArgs.builder()
 *                 .authentication(LocalBrokerAuthenticationMethodsArgs.builder()
 *                     .kubernetes(LocalBrokerKubernetesAuthenticationArgs.builder()
 *                         .secretPath("soukzfkouir")
 *                         .serviceAccountTokenName("suwetviuhmhorhvsidlznnufe")
 *                         .build())
 *                     .build())
 *                 .endpoint("xc")
 *                 .tls(LocalBrokerConnectionTlsArgs.builder()
 *                     .tlsEnabled(true)
 *                     .trustedCaCertificateConfigMap("rinkomfeznsfedbmllxlbmmhc")
 *                     .build())
 *                 .build())
 *             .location("mpbupgmqssnb")
 *             .logLevel("g")
 *             .mqName("s47Lj-S2S-Q-XY")
 *             .nodeTolerations(NodeTolerationsArgs.builder()
 *                 .effect("eeswvciblqmmaeesjoflyvxqbz")
 *                 .key("wbrstdwxgm")
 *                 .operator("lbegegneekwnyodtzraarivtwhmzep")
 *                 .value("sfafsjdcezdmkwibxeluukxgl")
 *                 .build())
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:KafkaConnector acntmeqjezkawbphgyprhwv /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/kafkaConnector/{kafkaConnectorName}
 * ```
 * @property clientIdPrefix The client id prefix of the dynamically generated client ids.
 * @property extendedLocation Extended Location
 * @property image The details of KafkaConnector Docker Image.
 * @property instances The number of KafkaConnector pods to spin up.
 * @property kafkaConnection The details for connecting with Remote Kafka Broker.
 * @property kafkaConnectorName Name of MQ kafkaConnector resource
 * @property localBrokerConnection The details for connecting with Local Broker.
 * @property location The geo-location where the resource lives
 * @property logLevel The log level of the Bridge Connector instances.
 * @property mqName Name of MQ resource
 * @property nodeTolerations The Node Tolerations for the Bridge Connector pods.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class KafkaConnectorArgs(
    public val clientIdPrefix: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val image: Output<ContainerImageArgs>? = null,
    public val instances: Output<Int>? = null,
    public val kafkaConnection: Output<KafkaRemoteBrokerConnectionSpecArgs>? = null,
    public val kafkaConnectorName: Output<String>? = null,
    public val localBrokerConnection: Output<LocalBrokerConnectionSpecArgs>? = null,
    public val location: Output<String>? = null,
    public val logLevel: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val nodeTolerations: Output<NodeTolerationsArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs =
        com.pulumi.azurenative.iotoperationsmq.KafkaConnectorArgs.builder()
            .clientIdPrefix(clientIdPrefix?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .image(image?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .instances(instances?.applyValue({ args0 -> args0 }))
            .kafkaConnection(kafkaConnection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kafkaConnectorName(kafkaConnectorName?.applyValue({ args0 -> args0 }))
            .localBrokerConnection(
                localBrokerConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .nodeTolerations(nodeTolerations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [KafkaConnectorArgs].
 */
@PulumiTagMarker
public class KafkaConnectorArgsBuilder internal constructor() {
    private var clientIdPrefix: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var image: Output<ContainerImageArgs>? = null

    private var instances: Output<Int>? = null

    private var kafkaConnection: Output<KafkaRemoteBrokerConnectionSpecArgs>? = null

    private var kafkaConnectorName: Output<String>? = null

    private var localBrokerConnection: Output<LocalBrokerConnectionSpecArgs>? = null

    private var location: Output<String>? = null

    private var logLevel: Output<String>? = null

    private var mqName: Output<String>? = null

    private var nodeTolerations: Output<NodeTolerationsArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The client id prefix of the dynamically generated client ids.
     */
    @JvmName("tpbkhcakkyynuvqx")
    public suspend fun clientIdPrefix(`value`: Output<String>) {
        this.clientIdPrefix = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("lbhfjvgvcxtyegnv")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The details of KafkaConnector Docker Image.
     */
    @JvmName("pajrttgbansaxbsg")
    public suspend fun image(`value`: Output<ContainerImageArgs>) {
        this.image = value
    }

    /**
     * @param value The number of KafkaConnector pods to spin up.
     */
    @JvmName("pgycxksadxvjbrul")
    public suspend fun instances(`value`: Output<Int>) {
        this.instances = value
    }

    /**
     * @param value The details for connecting with Remote Kafka Broker.
     */
    @JvmName("vnhxaflaykkavvck")
    public suspend fun kafkaConnection(`value`: Output<KafkaRemoteBrokerConnectionSpecArgs>) {
        this.kafkaConnection = value
    }

    /**
     * @param value Name of MQ kafkaConnector resource
     */
    @JvmName("jotmxbxjdbgtppno")
    public suspend fun kafkaConnectorName(`value`: Output<String>) {
        this.kafkaConnectorName = value
    }

    /**
     * @param value The details for connecting with Local Broker.
     */
    @JvmName("oxrjgxbhvnidcjbn")
    public suspend fun localBrokerConnection(`value`: Output<LocalBrokerConnectionSpecArgs>) {
        this.localBrokerConnection = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hnwwirsrnqtxhqhu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The log level of the Bridge Connector instances.
     */
    @JvmName("hmvykfhbcyccpefu")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("frcddgjuokqscflf")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The Node Tolerations for the Bridge Connector pods.
     */
    @JvmName("halgcjkshnwwsiqr")
    public suspend fun nodeTolerations(`value`: Output<NodeTolerationsArgs>) {
        this.nodeTolerations = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("btfxpmaoaqxfjoiv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("whfwwewiiqhkqfbs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The client id prefix of the dynamically generated client ids.
     */
    @JvmName("lopgywersucelwjp")
    public suspend fun clientIdPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIdPrefix = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("bedxvtvclakbwwxg")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("ellmcaiomruglheb")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The details of KafkaConnector Docker Image.
     */
    @JvmName("xxahxmkfqhhfyttf")
    public suspend fun image(`value`: ContainerImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param argument The details of KafkaConnector Docker Image.
     */
    @JvmName("dpebvcrfncpixudj")
    public suspend fun image(argument: suspend ContainerImageArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.image = mapped
    }

    /**
     * @param value The number of KafkaConnector pods to spin up.
     */
    @JvmName("ilsdksdaovnjjksf")
    public suspend fun instances(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instances = mapped
    }

    /**
     * @param value The details for connecting with Remote Kafka Broker.
     */
    @JvmName("kjpgxqjofjhytufx")
    public suspend fun kafkaConnection(`value`: KafkaRemoteBrokerConnectionSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaConnection = mapped
    }

    /**
     * @param argument The details for connecting with Remote Kafka Broker.
     */
    @JvmName("alcydhorsivkhfnh")
    public suspend fun kafkaConnection(argument: suspend KafkaRemoteBrokerConnectionSpecArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaRemoteBrokerConnectionSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kafkaConnection = mapped
    }

    /**
     * @param value Name of MQ kafkaConnector resource
     */
    @JvmName("mkfhfpoytvpncrdb")
    public suspend fun kafkaConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kafkaConnectorName = mapped
    }

    /**
     * @param value The details for connecting with Local Broker.
     */
    @JvmName("gerowdxqqieqcyky")
    public suspend fun localBrokerConnection(`value`: LocalBrokerConnectionSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localBrokerConnection = mapped
    }

    /**
     * @param argument The details for connecting with Local Broker.
     */
    @JvmName("mxtcgptbdbkxthcp")
    public suspend fun localBrokerConnection(argument: suspend LocalBrokerConnectionSpecArgsBuilder.() -> Unit) {
        val toBeMapped = LocalBrokerConnectionSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.localBrokerConnection = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("liouiseixqxlceqj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The log level of the Bridge Connector instances.
     */
    @JvmName("vqlhsyjhcsqyqgvi")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("cewmiewgkoqebkdr")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The Node Tolerations for the Bridge Connector pods.
     */
    @JvmName("tireulhophinyxxw")
    public suspend fun nodeTolerations(`value`: NodeTolerationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeTolerations = mapped
    }

    /**
     * @param argument The Node Tolerations for the Bridge Connector pods.
     */
    @JvmName("inrmbpbghoxxmuld")
    public suspend fun nodeTolerations(argument: suspend NodeTolerationsArgsBuilder.() -> Unit) {
        val toBeMapped = NodeTolerationsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nodeTolerations = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("poohvvfvvmubiuvt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("raqlujayklttwgnv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("frswhdlwugkkgirt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KafkaConnectorArgs = KafkaConnectorArgs(
        clientIdPrefix = clientIdPrefix,
        extendedLocation = extendedLocation,
        image = image,
        instances = instances,
        kafkaConnection = kafkaConnection,
        kafkaConnectorName = kafkaConnectorName,
        localBrokerConnection = localBrokerConnection,
        location = location,
        logLevel = logLevel,
        mqName = mqName,
        nodeTolerations = nodeTolerations,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
