@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaRoutesResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaTopicMapBatchingResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaRoutesResponse.Companion.toKotlin as kafkaRoutesResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaTopicMapBatchingResponse.Companion.toKotlin as kafkaTopicMapBatchingResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [KafkaConnectorTopicMap].
 */
@PulumiTagMarker
public class KafkaConnectorTopicMapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KafkaConnectorTopicMapArgs = KafkaConnectorTopicMapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KafkaConnectorTopicMapArgsBuilder.() -> Unit) {
        val builder = KafkaConnectorTopicMapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KafkaConnectorTopicMap {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMap(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return KafkaConnectorTopicMap(builtJavaResource)
    }
}

/**
 * MQ kafkaConnector/topicMap resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### KafkaConnectorTopicMap_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kafkaConnectorTopicMap = new AzureNative.IoTOperationsMQ.KafkaConnectorTopicMap("kafkaConnectorTopicMap", new()
 *     {
 *         Batching = new AzureNative.IoTOperationsMQ.Inputs.KafkaTopicMapBatchingArgs
 *         {
 *             Enabled = true,
 *             LatencyMs = 9110,
 *             MaxBytes = 732052221,
 *             MaxMessages = 373078076,
 *         },
 *         Compression = AzureNative.IoTOperationsMQ.KafkaMessageCompressionType.None,
 *         CopyMqttProperties = "efpqgkycuawnzyubdyt",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = AzureNative.IoTOperationsMQ.ExtendedLocationType.CustomLocation,
 *         },
 *         KafkaConnectorName = "216VN",
 *         KafkaConnectorRef = "icivjwerdspx",
 *         Location = "pavphpzfsgdudpyvufyebqh",
 *         MqName = "-1-eD-7-J",
 *         PartitionKeyProperty = "c",
 *         PartitionStrategy = AzureNative.IoTOperationsMQ.KafkaPartitionStrategy.@Default,
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Routes = new[]
 *         {
 *             new AzureNative.IoTOperationsMQ.Inputs.KafkaRoutesArgs
 *             {
 *                 KafkaToMqtt = new AzureNative.IoTOperationsMQ.Inputs.KafkaToMqttRoutesArgs
 *                 {
 *                     ConsumerGroupId = "usork",
 *                     KafkaTopic = "ggwhwbsr",
 *                     MqttTopic = "jwvmmhfqqkkmqrpslbdfmpbdetfu",
 *                     Name = "lrnvudysggscnqvmnlkrk",
 *                     Qos = 1,
 *                 },
 *                 MqttToKafka = new AzureNative.IoTOperationsMQ.Inputs.MqttToKafkaRoutesArgs
 *                 {
 *                     KafkaAcks = AzureNative.IoTOperationsMQ.KafkaAcks.Zero,
 *                     KafkaTopic = "tellycttwulueqcpqf",
 *                     MqttTopic = "raipkrcwvdnnflywhgjwnquarf",
 *                     Name = "qpshqcaxvxnyjzimvchngupzezdei",
 *                     Qos = 1,
 *                     SharedSubscription = new AzureNative.IoTOperationsMQ.Inputs.KafkaSharedSubscriptionPropertiesArgs
 *                     {
 *                         GroupMinimumShareNumber = 216,
 *                         GroupName = "nwdyccsditzhchuksmi",
 *                     },
 *                 },
 *             },
 *         },
 *         Tags = null,
 *         TopicMapName = "q582ViEY-b7wF1OO2A",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewKafkaConnectorTopicMap(ctx, "kafkaConnectorTopicMap", &iotoperationsmq.KafkaConnectorTopicMapArgs{
 * 			Batching: &iotoperationsmq.KafkaTopicMapBatchingArgs{
 * 				Enabled:     pulumi.Bool(true),
 * 				LatencyMs:   pulumi.Int(9110),
 * 				MaxBytes:    pulumi.Float64(732052221),
 * 				MaxMessages: pulumi.Float64(373078076),
 * 			},
 * 			Compression:        pulumi.String(iotoperationsmq.KafkaMessageCompressionTypeNone),
 * 			CopyMqttProperties: pulumi.String("efpqgkycuawnzyubdyt"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String(iotoperationsmq.ExtendedLocationTypeCustomLocation),
 * 			},
 * 			KafkaConnectorName:   pulumi.String("216VN"),
 * 			KafkaConnectorRef:    pulumi.String("icivjwerdspx"),
 * 			Location:             pulumi.String("pavphpzfsgdudpyvufyebqh"),
 * 			MqName:               pulumi.String("-1-eD-7-J"),
 * 			PartitionKeyProperty: pulumi.String("c"),
 * 			PartitionStrategy:    pulumi.String(iotoperationsmq.KafkaPartitionStrategyDefault),
 * 			ResourceGroupName:    pulumi.String("rgiotoperationsmq"),
 * 			Routes: iotoperationsmq.KafkaRoutesArray{
 * 				&iotoperationsmq.KafkaRoutesArgs{
 * 					KafkaToMqtt: &iotoperationsmq.KafkaToMqttRoutesArgs{
 * 						ConsumerGroupId: pulumi.String("usork"),
 * 						KafkaTopic:      pulumi.String("ggwhwbsr"),
 * 						MqttTopic:       pulumi.String("jwvmmhfqqkkmqrpslbdfmpbdetfu"),
 * 						Name:            pulumi.String("lrnvudysggscnqvmnlkrk"),
 * 						Qos:             pulumi.Int(1),
 * 					},
 * 					MqttToKafka: &iotoperationsmq.MqttToKafkaRoutesArgs{
 * 						KafkaAcks:  pulumi.String(iotoperationsmq.KafkaAcksZero),
 * 						KafkaTopic: pulumi.String("tellycttwulueqcpqf"),
 * 						MqttTopic:  pulumi.String("raipkrcwvdnnflywhgjwnquarf"),
 * 						Name:       pulumi.String("qpshqcaxvxnyjzimvchngupzezdei"),
 * 						Qos:        pulumi.Int(1),
 * 						SharedSubscription: &iotoperationsmq.KafkaSharedSubscriptionPropertiesArgs{
 * 							GroupMinimumShareNumber: pulumi.Int(216),
 * 							GroupName:               pulumi.String("nwdyccsditzhchuksmi"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags:         nil,
 * 			TopicMapName: pulumi.String("q582ViEY-b7wF1OO2A"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMap;
 * import com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMapArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTopicMapBatchingArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.ExtendedLocationPropertyArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRoutesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaToMqttRoutesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.MqttToKafkaRoutesArgs;
 * import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaSharedSubscriptionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kafkaConnectorTopicMap = new KafkaConnectorTopicMap("kafkaConnectorTopicMap", KafkaConnectorTopicMapArgs.builder()
 *             .batching(KafkaTopicMapBatchingArgs.builder()
 *                 .enabled(true)
 *                 .latencyMs(9110)
 *                 .maxBytes(732052221)
 *                 .maxMessages(373078076)
 *                 .build())
 *             .compression("none")
 *             .copyMqttProperties("efpqgkycuawnzyubdyt")
 *             .extendedLocation(ExtendedLocationPropertyArgs.builder()
 *                 .name("an")
 *                 .type("CustomLocation")
 *                 .build())
 *             .kafkaConnectorName("216VN")
 *             .kafkaConnectorRef("icivjwerdspx")
 *             .location("pavphpzfsgdudpyvufyebqh")
 *             .mqName("-1-eD-7-J")
 *             .partitionKeyProperty("c")
 *             .partitionStrategy("default")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .routes(KafkaRoutesArgs.builder()
 *                 .kafkaToMqtt(KafkaToMqttRoutesArgs.builder()
 *                     .consumerGroupId("usork")
 *                     .kafkaTopic("ggwhwbsr")
 *                     .mqttTopic("jwvmmhfqqkkmqrpslbdfmpbdetfu")
 *                     .name("lrnvudysggscnqvmnlkrk")
 *                     .qos(1)
 *                     .build())
 *                 .mqttToKafka(MqttToKafkaRoutesArgs.builder()
 *                     .kafkaAcks("zero")
 *                     .kafkaTopic("tellycttwulueqcpqf")
 *                     .mqttTopic("raipkrcwvdnnflywhgjwnquarf")
 *                     .name("qpshqcaxvxnyjzimvchngupzezdei")
 *                     .qos(1)
 *                     .sharedSubscription(KafkaSharedSubscriptionPropertiesArgs.builder()
 *                         .groupMinimumShareNumber(216)
 *                         .groupName("nwdyccsditzhchuksmi")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .tags()
 *             .topicMapName("q582ViEY-b7wF1OO2A")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:KafkaConnectorTopicMap kdcutfmwzjixcfzbkpelp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/kafkaConnector/{kafkaConnectorName}/topicMap/{topicMapName}
 * ```
 */
public class KafkaConnectorTopicMap internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMap,
) : KotlinCustomResource(javaResource, KafkaConnectorTopicMapMapper) {
    /**
     * The batching settings for kafka messages.
     */
    public val batching: Output<KafkaTopicMapBatchingResponse>?
        get() = javaResource.batching().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    kafkaTopicMapBatchingResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The compression to use for kafka messages.
     */
    public val compression: Output<String>?
        get() = javaResource.compression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The flag to copy Mqtt properties.
     */
    public val copyMqttProperties: Output<String>?
        get() = javaResource.copyMqttProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The kafkaConnector CRD it refers to.
     */
    public val kafkaConnectorRef: Output<String>
        get() = javaResource.kafkaConnectorRef().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The partition to use for Kafka.
     */
    public val partitionKeyProperty: Output<String>?
        get() = javaResource.partitionKeyProperty().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The partition strategy to use for Kafka.
     */
    public val partitionStrategy: Output<String>?
        get() = javaResource.partitionStrategy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The route details for Kafka connector.
     */
    public val routes: Output<List<KafkaRoutesResponse>>
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    kafkaRoutesResponseToKotlin(args0)
                })
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KafkaConnectorTopicMapMapper : ResourceMapper<KafkaConnectorTopicMap> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMap::class == javaResource::class

    override fun map(javaResource: Resource): KafkaConnectorTopicMap =
        KafkaConnectorTopicMap(
            javaResource as
                com.pulumi.azurenative.iotoperationsmq.KafkaConnectorTopicMap,
        )
}

/**
 * @see [KafkaConnectorTopicMap].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KafkaConnectorTopicMap].
 */
public suspend fun kafkaConnectorTopicMap(
    name: String,
    block: suspend KafkaConnectorTopicMapResourceBuilder.() -> Unit,
): KafkaConnectorTopicMap {
    val builder = KafkaConnectorTopicMapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KafkaConnectorTopicMap].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kafkaConnectorTopicMap(name: String): KafkaConnectorTopicMap {
    val builder = KafkaConnectorTopicMapResourceBuilder()
    builder.name(name)
    return builder.build()
}
