@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Memory profile of broker.
 */
public enum class BrokerMemoryProfile(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.BrokerMemoryProfile,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.BrokerMemoryProfile> {
    /**
     * Tiny memory profile.
     */
    Tiny(com.pulumi.azurenative.iotoperationsmq.enums.BrokerMemoryProfile.Tiny),

    /**
     * Low memory profile.
     */
    Low(com.pulumi.azurenative.iotoperationsmq.enums.BrokerMemoryProfile.Low),

    /**
     * Medium memory profile.
     */
    Medium(com.pulumi.azurenative.iotoperationsmq.enums.BrokerMemoryProfile.Medium),

    /**
     * High memory profile.
     */
    High(com.pulumi.azurenative.iotoperationsmq.enums.BrokerMemoryProfile.High),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.BrokerMemoryProfile =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.BrokerMemoryProfile): BrokerMemoryProfile = BrokerMemoryProfile.values().first { it.javaValue == javaType }
    }
}
