@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Direction of the route.
 */
public enum class MqttBridgeRouteDirection(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.MqttBridgeRouteDirection,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.MqttBridgeRouteDirection> {
    /**
     * Remote to Local Broker.
     */
    RemoteToLocal(com.pulumi.azurenative.iotoperationsmq.enums.MqttBridgeRouteDirection.RemoteToLocal),

    /**
     * Local to Remote Broker.
     */
    LocalToRemote(com.pulumi.azurenative.iotoperationsmq.enums.MqttBridgeRouteDirection.LocalToRemote),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.MqttBridgeRouteDirection =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.MqttBridgeRouteDirection): MqttBridgeRouteDirection =
            MqttBridgeRouteDirection.values().first { it.javaValue == javaType }
    }
}
