@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of action that the clients can perform on the broker: Connect, Publish or Subscribe.
 */
public enum class ResourceInfoDefinitionMethods(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.ResourceInfoDefinitionMethods,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.ResourceInfoDefinitionMethods> {
    /**
     * Allowed Connecting to Broker
     */
    Connect(com.pulumi.azurenative.iotoperationsmq.enums.ResourceInfoDefinitionMethods.Connect),

    /**
     * Allowed Publishing to Broker
     */
    Publish(com.pulumi.azurenative.iotoperationsmq.enums.ResourceInfoDefinitionMethods.Publish),

    /**
     * Allowed Subscribing to Broker
     */
    Subscribe(com.pulumi.azurenative.iotoperationsmq.enums.ResourceInfoDefinitionMethods.Subscribe),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.ResourceInfoDefinitionMethods = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.ResourceInfoDefinitionMethods): ResourceInfoDefinitionMethods =
            ResourceInfoDefinitionMethods.values().first { it.javaValue == javaType }
    }
}
