@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The Kubernetes Service type to deploy for Listener.
 */
public enum class ServiceType(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.ServiceType,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.ServiceType> {
    /**
     * Cluster IP Service.
     */
    ClusterIp(com.pulumi.azurenative.iotoperationsmq.enums.ServiceType.ClusterIp),

    /**
     * Load Balancer Service.
     */
    LoadBalancer(com.pulumi.azurenative.iotoperationsmq.enums.ServiceType.LoadBalancer),

    /**
     * Node Port Service.
     */
    NodePort(com.pulumi.azurenative.iotoperationsmq.enums.ServiceType.NodePort),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.ServiceType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.ServiceType): ServiceType = ServiceType.values().first { it.javaValue == javaType }
    }
}
